/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the volume of attacks during the time period, included in an <a>AttackStatisticsDataItem</a>. If
 * the accompanying <code>AttackCount</code> in the statistics object is zero, this setting might be empty.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttackVolume implements SdkPojo, Serializable, ToCopyableBuilder<AttackVolume.Builder, AttackVolume> {
    private static final SdkField<AttackVolumeStatistics> BITS_PER_SECOND_FIELD = SdkField
            .<AttackVolumeStatistics> builder(MarshallingType.SDK_POJO).memberName("BitsPerSecond")
            .getter(getter(AttackVolume::bitsPerSecond)).setter(setter(Builder::bitsPerSecond))
            .constructor(AttackVolumeStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BitsPerSecond").build()).build();

    private static final SdkField<AttackVolumeStatistics> PACKETS_PER_SECOND_FIELD = SdkField
            .<AttackVolumeStatistics> builder(MarshallingType.SDK_POJO).memberName("PacketsPerSecond")
            .getter(getter(AttackVolume::packetsPerSecond)).setter(setter(Builder::packetsPerSecond))
            .constructor(AttackVolumeStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketsPerSecond").build()).build();

    private static final SdkField<AttackVolumeStatistics> REQUESTS_PER_SECOND_FIELD = SdkField
            .<AttackVolumeStatistics> builder(MarshallingType.SDK_POJO).memberName("RequestsPerSecond")
            .getter(getter(AttackVolume::requestsPerSecond)).setter(setter(Builder::requestsPerSecond))
            .constructor(AttackVolumeStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestsPerSecond").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITS_PER_SECOND_FIELD,
            PACKETS_PER_SECOND_FIELD, REQUESTS_PER_SECOND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AttackVolumeStatistics bitsPerSecond;

    private final AttackVolumeStatistics packetsPerSecond;

    private final AttackVolumeStatistics requestsPerSecond;

    private AttackVolume(BuilderImpl builder) {
        this.bitsPerSecond = builder.bitsPerSecond;
        this.packetsPerSecond = builder.packetsPerSecond;
        this.requestsPerSecond = builder.requestsPerSecond;
    }

    /**
     * <p>
     * A statistics object that uses bits per second as the unit. This is included for network level attacks.
     * </p>
     * 
     * @return A statistics object that uses bits per second as the unit. This is included for network level attacks.
     */
    public final AttackVolumeStatistics bitsPerSecond() {
        return bitsPerSecond;
    }

    /**
     * <p>
     * A statistics object that uses packets per second as the unit. This is included for network level attacks.
     * </p>
     * 
     * @return A statistics object that uses packets per second as the unit. This is included for network level attacks.
     */
    public final AttackVolumeStatistics packetsPerSecond() {
        return packetsPerSecond;
    }

    /**
     * <p>
     * A statistics object that uses requests per second as the unit. This is included for application level attacks,
     * and is only available for accounts that are subscribed to Shield Advanced.
     * </p>
     * 
     * @return A statistics object that uses requests per second as the unit. This is included for application level
     *         attacks, and is only available for accounts that are subscribed to Shield Advanced.
     */
    public final AttackVolumeStatistics requestsPerSecond() {
        return requestsPerSecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(packetsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(requestsPerSecond());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackVolume)) {
            return false;
        }
        AttackVolume other = (AttackVolume) obj;
        return Objects.equals(bitsPerSecond(), other.bitsPerSecond())
                && Objects.equals(packetsPerSecond(), other.packetsPerSecond())
                && Objects.equals(requestsPerSecond(), other.requestsPerSecond());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttackVolume").add("BitsPerSecond", bitsPerSecond()).add("PacketsPerSecond", packetsPerSecond())
                .add("RequestsPerSecond", requestsPerSecond()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BitsPerSecond":
            return Optional.ofNullable(clazz.cast(bitsPerSecond()));
        case "PacketsPerSecond":
            return Optional.ofNullable(clazz.cast(packetsPerSecond()));
        case "RequestsPerSecond":
            return Optional.ofNullable(clazz.cast(requestsPerSecond()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BitsPerSecond", BITS_PER_SECOND_FIELD);
        map.put("PacketsPerSecond", PACKETS_PER_SECOND_FIELD);
        map.put("RequestsPerSecond", REQUESTS_PER_SECOND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttackVolume, T> g) {
        return obj -> g.apply((AttackVolume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttackVolume> {
        /**
         * <p>
         * A statistics object that uses bits per second as the unit. This is included for network level attacks.
         * </p>
         * 
         * @param bitsPerSecond
         *        A statistics object that uses bits per second as the unit. This is included for network level attacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitsPerSecond(AttackVolumeStatistics bitsPerSecond);

        /**
         * <p>
         * A statistics object that uses bits per second as the unit. This is included for network level attacks.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttackVolumeStatistics.Builder} avoiding
         * the need to create one manually via {@link AttackVolumeStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttackVolumeStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #bitsPerSecond(AttackVolumeStatistics)}.
         * 
         * @param bitsPerSecond
         *        a consumer that will call methods on {@link AttackVolumeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bitsPerSecond(AttackVolumeStatistics)
         */
        default Builder bitsPerSecond(Consumer<AttackVolumeStatistics.Builder> bitsPerSecond) {
            return bitsPerSecond(AttackVolumeStatistics.builder().applyMutation(bitsPerSecond).build());
        }

        /**
         * <p>
         * A statistics object that uses packets per second as the unit. This is included for network level attacks.
         * </p>
         * 
         * @param packetsPerSecond
         *        A statistics object that uses packets per second as the unit. This is included for network level
         *        attacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetsPerSecond(AttackVolumeStatistics packetsPerSecond);

        /**
         * <p>
         * A statistics object that uses packets per second as the unit. This is included for network level attacks.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttackVolumeStatistics.Builder} avoiding
         * the need to create one manually via {@link AttackVolumeStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttackVolumeStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #packetsPerSecond(AttackVolumeStatistics)}.
         * 
         * @param packetsPerSecond
         *        a consumer that will call methods on {@link AttackVolumeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packetsPerSecond(AttackVolumeStatistics)
         */
        default Builder packetsPerSecond(Consumer<AttackVolumeStatistics.Builder> packetsPerSecond) {
            return packetsPerSecond(AttackVolumeStatistics.builder().applyMutation(packetsPerSecond).build());
        }

        /**
         * <p>
         * A statistics object that uses requests per second as the unit. This is included for application level
         * attacks, and is only available for accounts that are subscribed to Shield Advanced.
         * </p>
         * 
         * @param requestsPerSecond
         *        A statistics object that uses requests per second as the unit. This is included for application level
         *        attacks, and is only available for accounts that are subscribed to Shield Advanced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestsPerSecond(AttackVolumeStatistics requestsPerSecond);

        /**
         * <p>
         * A statistics object that uses requests per second as the unit. This is included for application level
         * attacks, and is only available for accounts that are subscribed to Shield Advanced.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttackVolumeStatistics.Builder} avoiding
         * the need to create one manually via {@link AttackVolumeStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttackVolumeStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #requestsPerSecond(AttackVolumeStatistics)}.
         * 
         * @param requestsPerSecond
         *        a consumer that will call methods on {@link AttackVolumeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestsPerSecond(AttackVolumeStatistics)
         */
        default Builder requestsPerSecond(Consumer<AttackVolumeStatistics.Builder> requestsPerSecond) {
            return requestsPerSecond(AttackVolumeStatistics.builder().applyMutation(requestsPerSecond).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AttackVolumeStatistics bitsPerSecond;

        private AttackVolumeStatistics packetsPerSecond;

        private AttackVolumeStatistics requestsPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackVolume model) {
            bitsPerSecond(model.bitsPerSecond);
            packetsPerSecond(model.packetsPerSecond);
            requestsPerSecond(model.requestsPerSecond);
        }

        public final AttackVolumeStatistics.Builder getBitsPerSecond() {
            return bitsPerSecond != null ? bitsPerSecond.toBuilder() : null;
        }

        public final void setBitsPerSecond(AttackVolumeStatistics.BuilderImpl bitsPerSecond) {
            this.bitsPerSecond = bitsPerSecond != null ? bitsPerSecond.build() : null;
        }

        @Override
        public final Builder bitsPerSecond(AttackVolumeStatistics bitsPerSecond) {
            this.bitsPerSecond = bitsPerSecond;
            return this;
        }

        public final AttackVolumeStatistics.Builder getPacketsPerSecond() {
            return packetsPerSecond != null ? packetsPerSecond.toBuilder() : null;
        }

        public final void setPacketsPerSecond(AttackVolumeStatistics.BuilderImpl packetsPerSecond) {
            this.packetsPerSecond = packetsPerSecond != null ? packetsPerSecond.build() : null;
        }

        @Override
        public final Builder packetsPerSecond(AttackVolumeStatistics packetsPerSecond) {
            this.packetsPerSecond = packetsPerSecond;
            return this;
        }

        public final AttackVolumeStatistics.Builder getRequestsPerSecond() {
            return requestsPerSecond != null ? requestsPerSecond.toBuilder() : null;
        }

        public final void setRequestsPerSecond(AttackVolumeStatistics.BuilderImpl requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond != null ? requestsPerSecond.build() : null;
        }

        @Override
        public final Builder requestsPerSecond(AttackVolumeStatistics requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond;
            return this;
        }

        @Override
        public AttackVolume build() {
            return new AttackVolume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
