/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.shield.endpoints.ShieldEndpointParams;
import software.amazon.awssdk.services.shield.endpoints.ShieldEndpointProvider;
import software.amazon.awssdk.services.shield.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.shield.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.shield.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultShieldEndpointProvider
implements ShieldEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(ShieldEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultShieldEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(ShieldEndpointParams params, String region) {
        RuleResult result = DefaultShieldEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultShieldEndpointProvider.endpointRule5(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule1(ShieldEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(ShieldEndpointParams params, String region) {
        if (region != null) {
            return DefaultShieldEndpointProvider.endpointRule6(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(ShieldEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            if ("aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://shield.us-east-1.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("shield").signingRegion("us-east-1").build())).build());
            }
            if ("aws".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://shield-fips.us-east-1.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("shield").signingRegion("us-east-1").build())).build());
            }
            RuleResult result = DefaultShieldEndpointProvider.endpointRule9(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultShieldEndpointProvider.endpointRule13(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultShieldEndpointProvider.endpointRule17(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://shield." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(ShieldEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultShieldEndpointProvider.endpointRule10(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(ShieldEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://shield-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(ShieldEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultShieldEndpointProvider.endpointRule14(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(ShieldEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://shield-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(ShieldEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultShieldEndpointProvider.endpointRule18(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(ShieldEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://shield." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

