/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.ProtectedResourceType;
import software.amazon.awssdk.services.shield.model.ProtectedResourceTypeFiltersCopier;
import software.amazon.awssdk.services.shield.model.ProtectionGroupAggregation;
import software.amazon.awssdk.services.shield.model.ProtectionGroupAggregationFiltersCopier;
import software.amazon.awssdk.services.shield.model.ProtectionGroupIdFiltersCopier;
import software.amazon.awssdk.services.shield.model.ProtectionGroupPattern;
import software.amazon.awssdk.services.shield.model.ProtectionGroupPatternFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InclusionProtectionGroupFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InclusionProtectionGroupFilters> {
    private static final SdkField<List<String>> PROTECTION_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtectionGroupIds").getter(InclusionProtectionGroupFilters.getter(InclusionProtectionGroupFilters::protectionGroupIds)).setter(InclusionProtectionGroupFilters.setter(Builder::protectionGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Patterns").getter(InclusionProtectionGroupFilters.getter(InclusionProtectionGroupFilters::patternsAsStrings)).setter(InclusionProtectionGroupFilters.setter(Builder::patternsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Patterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(InclusionProtectionGroupFilters.getter(InclusionProtectionGroupFilters::resourceTypesAsStrings)).setter(InclusionProtectionGroupFilters.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AGGREGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggregations").getter(InclusionProtectionGroupFilters.getter(InclusionProtectionGroupFilters::aggregationsAsStrings)).setter(InclusionProtectionGroupFilters.setter(Builder::aggregationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_GROUP_IDS_FIELD, PATTERNS_FIELD, RESOURCE_TYPES_FIELD, AGGREGATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InclusionProtectionGroupFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> protectionGroupIds;
    private final List<String> patterns;
    private final List<String> resourceTypes;
    private final List<String> aggregations;

    private InclusionProtectionGroupFilters(BuilderImpl builder) {
        this.protectionGroupIds = builder.protectionGroupIds;
        this.patterns = builder.patterns;
        this.resourceTypes = builder.resourceTypes;
        this.aggregations = builder.aggregations;
    }

    public final boolean hasProtectionGroupIds() {
        return this.protectionGroupIds != null && !(this.protectionGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> protectionGroupIds() {
        return this.protectionGroupIds;
    }

    public final List<ProtectionGroupPattern> patterns() {
        return ProtectionGroupPatternFiltersCopier.copyStringToEnum(this.patterns);
    }

    public final boolean hasPatterns() {
        return this.patterns != null && !(this.patterns instanceof SdkAutoConstructList);
    }

    public final List<String> patternsAsStrings() {
        return this.patterns;
    }

    public final List<ProtectedResourceType> resourceTypes() {
        return ProtectedResourceTypeFiltersCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public final List<ProtectionGroupAggregation> aggregations() {
        return ProtectionGroupAggregationFiltersCopier.copyStringToEnum(this.aggregations);
    }

    public final boolean hasAggregations() {
        return this.aggregations != null && !(this.aggregations instanceof SdkAutoConstructList);
    }

    public final List<String> aggregationsAsStrings() {
        return this.aggregations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtectionGroupIds() ? this.protectionGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPatterns() ? this.patternsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregations() ? this.aggregationsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InclusionProtectionGroupFilters)) {
            return false;
        }
        InclusionProtectionGroupFilters other = (InclusionProtectionGroupFilters)obj;
        return this.hasProtectionGroupIds() == other.hasProtectionGroupIds() && Objects.equals(this.protectionGroupIds(), other.protectionGroupIds()) && this.hasPatterns() == other.hasPatterns() && Objects.equals(this.patternsAsStrings(), other.patternsAsStrings()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && this.hasAggregations() == other.hasAggregations() && Objects.equals(this.aggregationsAsStrings(), other.aggregationsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"InclusionProtectionGroupFilters").add("ProtectionGroupIds", this.hasProtectionGroupIds() ? this.protectionGroupIds() : null).add("Patterns", this.hasPatterns() ? this.patternsAsStrings() : null).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).add("Aggregations", this.hasAggregations() ? this.aggregationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectionGroupIds": {
                return Optional.ofNullable(clazz.cast(this.protectionGroupIds()));
            }
            case "Patterns": {
                return Optional.ofNullable(clazz.cast(this.patternsAsStrings()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "Aggregations": {
                return Optional.ofNullable(clazz.cast(this.aggregationsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ProtectionGroupIds", PROTECTION_GROUP_IDS_FIELD);
        map.put("Patterns", PATTERNS_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("Aggregations", AGGREGATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InclusionProtectionGroupFilters, T> g) {
        return obj -> g.apply((InclusionProtectionGroupFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> protectionGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> patterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> aggregations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InclusionProtectionGroupFilters model) {
            this.protectionGroupIds(model.protectionGroupIds);
            this.patternsWithStrings(model.patterns);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.aggregationsWithStrings(model.aggregations);
        }

        public final Collection<String> getProtectionGroupIds() {
            if (this.protectionGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protectionGroupIds;
        }

        public final void setProtectionGroupIds(Collection<String> protectionGroupIds) {
            this.protectionGroupIds = ProtectionGroupIdFiltersCopier.copy(protectionGroupIds);
        }

        @Override
        public final Builder protectionGroupIds(Collection<String> protectionGroupIds) {
            this.protectionGroupIds = ProtectionGroupIdFiltersCopier.copy(protectionGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectionGroupIds(String ... protectionGroupIds) {
            this.protectionGroupIds(Arrays.asList(protectionGroupIds));
            return this;
        }

        public final Collection<String> getPatterns() {
            if (this.patterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.patterns;
        }

        public final void setPatterns(Collection<String> patterns) {
            this.patterns = ProtectionGroupPatternFiltersCopier.copy(patterns);
        }

        @Override
        public final Builder patternsWithStrings(Collection<String> patterns) {
            this.patterns = ProtectionGroupPatternFiltersCopier.copy(patterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patternsWithStrings(String ... patterns) {
            this.patternsWithStrings(Arrays.asList(patterns));
            return this;
        }

        @Override
        public final Builder patterns(Collection<ProtectionGroupPattern> patterns) {
            this.patterns = ProtectionGroupPatternFiltersCopier.copyEnumToString(patterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patterns(ProtectionGroupPattern ... patterns) {
            this.patterns(Arrays.asList(patterns));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ProtectedResourceType> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ProtectedResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getAggregations() {
            if (this.aggregations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aggregations;
        }

        public final void setAggregations(Collection<String> aggregations) {
            this.aggregations = ProtectionGroupAggregationFiltersCopier.copy(aggregations);
        }

        @Override
        public final Builder aggregationsWithStrings(Collection<String> aggregations) {
            this.aggregations = ProtectionGroupAggregationFiltersCopier.copy(aggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationsWithStrings(String ... aggregations) {
            this.aggregationsWithStrings(Arrays.asList(aggregations));
            return this;
        }

        @Override
        public final Builder aggregations(Collection<ProtectionGroupAggregation> aggregations) {
            this.aggregations = ProtectionGroupAggregationFiltersCopier.copyEnumToString(aggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregations(ProtectionGroupAggregation ... aggregations) {
            this.aggregations(Arrays.asList(aggregations));
            return this;
        }

        public InclusionProtectionGroupFilters build() {
            return new InclusionProtectionGroupFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InclusionProtectionGroupFilters> {
        public Builder protectionGroupIds(Collection<String> var1);

        public Builder protectionGroupIds(String ... var1);

        public Builder patternsWithStrings(Collection<String> var1);

        public Builder patternsWithStrings(String ... var1);

        public Builder patterns(Collection<ProtectionGroupPattern> var1);

        public Builder patterns(ProtectionGroupPattern ... var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ProtectedResourceType> var1);

        public Builder resourceTypes(ProtectedResourceType ... var1);

        public Builder aggregationsWithStrings(Collection<String> var1);

        public Builder aggregationsWithStrings(String ... var1);

        public Builder aggregations(Collection<ProtectionGroupAggregation> var1);

        public Builder aggregations(ProtectionGroupAggregation ... var1);
    }
}

