/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AttackLayer {
    NETWORK("NETWORK"),
    APPLICATION("APPLICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AttackLayer> VALUE_MAP;
    private final String value;

    private AttackLayer(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttackLayer fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttackLayer> knownValues() {
        EnumSet<AttackLayer> knownValues = EnumSet.allOf(AttackLayer.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AttackLayer.class, AttackLayer::toString);
    }
}

