/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.shield.model.ApplicationLayerAutomaticResponseStatus;
import software.amazon.awssdk.services.shield.model.ResponseAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationLayerAutomaticResponseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationLayerAutomaticResponseConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ApplicationLayerAutomaticResponseConfiguration.getter(ApplicationLayerAutomaticResponseConfiguration::statusAsString)).setter(ApplicationLayerAutomaticResponseConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ResponseAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(ApplicationLayerAutomaticResponseConfiguration.getter(ApplicationLayerAutomaticResponseConfiguration::action)).setter(ApplicationLayerAutomaticResponseConfiguration.setter(Builder::action)).constructor(ResponseAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("Action", ACTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final ResponseAction action;

    private ApplicationLayerAutomaticResponseConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.action = builder.action;
    }

    public final ApplicationLayerAutomaticResponseStatus status() {
        return ApplicationLayerAutomaticResponseStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ResponseAction action() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationLayerAutomaticResponseConfiguration)) {
            return false;
        }
        ApplicationLayerAutomaticResponseConfiguration other = (ApplicationLayerAutomaticResponseConfiguration)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.action(), other.action());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationLayerAutomaticResponseConfiguration").add("Status", (Object)this.statusAsString()).add("Action", (Object)this.action()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationLayerAutomaticResponseConfiguration, T> g) {
        return obj -> g.apply((ApplicationLayerAutomaticResponseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private ResponseAction action;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationLayerAutomaticResponseConfiguration model) {
            this.status(model.status);
            this.action(model.action);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationLayerAutomaticResponseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ResponseAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(ResponseAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ResponseAction action) {
            this.action = action;
            return this;
        }

        public ApplicationLayerAutomaticResponseConfiguration build() {
            return new ApplicationLayerAutomaticResponseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationLayerAutomaticResponseConfiguration> {
        public Builder status(String var1);

        public Builder status(ApplicationLayerAutomaticResponseStatus var1);

        public Builder action(ResponseAction var1);

        default public Builder action(Consumer<ResponseAction.Builder> action) {
            return this.action((ResponseAction)((ResponseAction.Builder)ResponseAction.builder().applyMutation(action)).build());
        }
    }
}

