/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.shield.DefaultShieldAsyncClient;
import software.amazon.awssdk.services.shield.DefaultShieldBaseClientBuilder;
import software.amazon.awssdk.services.shield.ShieldAsyncClient;
import software.amazon.awssdk.services.shield.ShieldAsyncClientBuilder;
import software.amazon.awssdk.services.shield.ShieldServiceClientConfiguration;
import software.amazon.awssdk.services.shield.endpoints.ShieldEndpointProvider;

@SdkInternalApi
final class DefaultShieldAsyncClientBuilder
extends DefaultShieldBaseClientBuilder<ShieldAsyncClientBuilder, ShieldAsyncClient>
implements ShieldAsyncClientBuilder {
    DefaultShieldAsyncClientBuilder() {
    }

    @Override
    public DefaultShieldAsyncClientBuilder endpointProvider(ShieldEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ShieldAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultShieldAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ShieldServiceClientConfiguration serviceClientConfiguration = ShieldServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultShieldAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

