/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProtectedResourceType {
    CLOUDFRONT_DISTRIBUTION("CLOUDFRONT_DISTRIBUTION"),
    ROUTE_53_HOSTED_ZONE("ROUTE_53_HOSTED_ZONE"),
    ELASTIC_IP_ALLOCATION("ELASTIC_IP_ALLOCATION"),
    CLASSIC_LOAD_BALANCER("CLASSIC_LOAD_BALANCER"),
    APPLICATION_LOAD_BALANCER("APPLICATION_LOAD_BALANCER"),
    GLOBAL_ACCELERATOR("GLOBAL_ACCELERATOR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProtectedResourceType> VALUE_MAP;
    private final String value;

    private ProtectedResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProtectedResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProtectedResourceType> knownValues() {
        EnumSet<ProtectedResourceType> knownValues = EnumSet.allOf(ProtectedResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProtectedResourceType.class, ProtectedResourceType::toString);
    }
}

