/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.AttackSummariesCopier;
import software.amazon.awssdk.services.shield.model.AttackSummary;
import software.amazon.awssdk.services.shield.model.ShieldResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAttacksResponse
extends ShieldResponse
implements ToCopyableBuilder<Builder, ListAttacksResponse> {
    private static final SdkField<List<AttackSummary>> ATTACK_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttackSummaries").getter(ListAttacksResponse.getter(ListAttacksResponse::attackSummaries)).setter(ListAttacksResponse.setter(Builder::attackSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttackSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAttacksResponse.getter(ListAttacksResponse::nextToken)).setter(ListAttacksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AttackSummary> attackSummaries;
    private final String nextToken;

    private ListAttacksResponse(BuilderImpl builder) {
        super(builder);
        this.attackSummaries = builder.attackSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAttackSummaries() {
        return this.attackSummaries != null && !(this.attackSummaries instanceof SdkAutoConstructList);
    }

    public final List<AttackSummary> attackSummaries() {
        return this.attackSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttackSummaries() ? this.attackSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttacksResponse)) {
            return false;
        }
        ListAttacksResponse other = (ListAttacksResponse)((Object)obj);
        return this.hasAttackSummaries() == other.hasAttackSummaries() && Objects.equals(this.attackSummaries(), other.attackSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAttacksResponse").add("AttackSummaries", this.hasAttackSummaries() ? this.attackSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttackSummaries": {
                return Optional.ofNullable(clazz.cast(this.attackSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttacksResponse, T> g) {
        return obj -> g.apply((ListAttacksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldResponse.BuilderImpl
    implements Builder {
        private List<AttackSummary> attackSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttacksResponse model) {
            super(model);
            this.attackSummaries(model.attackSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AttackSummary.Builder> getAttackSummaries() {
            List<AttackSummary.Builder> result = AttackSummariesCopier.copyToBuilder(this.attackSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attackSummaries(Collection<AttackSummary> attackSummaries) {
            this.attackSummaries = AttackSummariesCopier.copy(attackSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackSummaries(AttackSummary ... attackSummaries) {
            this.attackSummaries(Arrays.asList(attackSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackSummaries(Consumer<AttackSummary.Builder> ... attackSummaries) {
            this.attackSummaries(Stream.of(attackSummaries).map(c -> (AttackSummary)((AttackSummary.Builder)AttackSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttackSummaries(Collection<AttackSummary.BuilderImpl> attackSummaries) {
            this.attackSummaries = AttackSummariesCopier.copyFromBuilder(attackSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAttacksResponse build() {
            return new ListAttacksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ShieldResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAttacksResponse> {
        public Builder attackSummaries(Collection<AttackSummary> var1);

        public Builder attackSummaries(AttackSummary ... var1);

        public Builder attackSummaries(Consumer<AttackSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

