/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.HealthCheckIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Protection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Protection> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Protection.getter(Protection::id)).setter(Protection.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Protection.getter(Protection::name)).setter(Protection.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(Protection.getter(Protection::resourceArn)).setter(Protection.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<List<String>> HEALTH_CHECK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HealthCheckIds").getter(Protection.getter(Protection::healthCheckIds)).setter(Protection.setter(Builder::healthCheckIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, RESOURCE_ARN_FIELD, HEALTH_CHECK_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String resourceArn;
    private final List<String> healthCheckIds;

    private Protection(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.resourceArn = builder.resourceArn;
        this.healthCheckIds = builder.healthCheckIds;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasHealthCheckIds() {
        return this.healthCheckIds != null && !(this.healthCheckIds instanceof SdkAutoConstructList);
    }

    public final List<String> healthCheckIds() {
        return this.healthCheckIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHealthCheckIds() ? this.healthCheckIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Protection)) {
            return false;
        }
        Protection other = (Protection)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasHealthCheckIds() == other.hasHealthCheckIds() && Objects.equals(this.healthCheckIds(), other.healthCheckIds());
    }

    public final String toString() {
        return ToString.builder((String)"Protection").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("ResourceArn", (Object)this.resourceArn()).add("HealthCheckIds", this.hasHealthCheckIds() ? this.healthCheckIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "HealthCheckIds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Protection, T> g) {
        return obj -> g.apply((Protection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String resourceArn;
        private List<String> healthCheckIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Protection model) {
            this.id(model.id);
            this.name(model.name);
            this.resourceArn(model.resourceArn);
            this.healthCheckIds(model.healthCheckIds);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<String> getHealthCheckIds() {
            if (this.healthCheckIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.healthCheckIds;
        }

        @Override
        public final Builder healthCheckIds(Collection<String> healthCheckIds) {
            this.healthCheckIds = HealthCheckIdsCopier.copy(healthCheckIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckIds(String ... healthCheckIds) {
            this.healthCheckIds(Arrays.asList(healthCheckIds));
            return this;
        }

        public final void setHealthCheckIds(Collection<String> healthCheckIds) {
            this.healthCheckIds = HealthCheckIdsCopier.copy(healthCheckIds);
        }

        public Protection build() {
            return new Protection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Protection> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder resourceArn(String var1);

        public Builder healthCheckIds(Collection<String> var1);

        public Builder healthCheckIds(String ... var1);
    }
}

