/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.shield.ShieldClient;
import software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupResponse;

public class ListResourcesInProtectionGroupIterable
implements SdkIterable<ListResourcesInProtectionGroupResponse> {
    private final ShieldClient client;
    private final ListResourcesInProtectionGroupRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourcesInProtectionGroupIterable(ShieldClient client, ListResourcesInProtectionGroupRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResourcesInProtectionGroupResponseFetcher();
    }

    public Iterator<ListResourcesInProtectionGroupResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListResourcesInProtectionGroupResponseFetcher
    implements SyncPageFetcher<ListResourcesInProtectionGroupResponse> {
        private ListResourcesInProtectionGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcesInProtectionGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourcesInProtectionGroupResponse nextPage(ListResourcesInProtectionGroupResponse previousPage) {
            if (previousPage == null) {
                return ListResourcesInProtectionGroupIterable.this.client.listResourcesInProtectionGroup(ListResourcesInProtectionGroupIterable.this.firstRequest);
            }
            return ListResourcesInProtectionGroupIterable.this.client.listResourcesInProtectionGroup((ListResourcesInProtectionGroupRequest)((Object)ListResourcesInProtectionGroupIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

