/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.AttackSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttackSummaryMarshaller {
    private static final MarshallingInfo<String> ATTACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<List> ATTACKVECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackVectors").isBinary(false).build();
    private static final AttackSummaryMarshaller INSTANCE = new AttackSummaryMarshaller();

    private AttackSummaryMarshaller() {
    }

    public static AttackSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttackSummary attackSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)attackSummary, (String)"attackSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attackSummary.attackId(), ATTACKID_BINDING);
            protocolMarshaller.marshall((Object)attackSummary.resourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)attackSummary.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)attackSummary.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(attackSummary.attackVectors(), ATTACKVECTORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

