/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;

public class SummarizedCounterUnmarshaller
implements Unmarshaller<SummarizedCounter, JsonUnmarshallerContext> {
    private static final SummarizedCounterUnmarshaller INSTANCE = new SummarizedCounterUnmarshaller();

    public SummarizedCounter unmarshall(JsonUnmarshallerContext context) throws Exception {
        SummarizedCounter.Builder summarizedCounterBuilder = SummarizedCounter.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    summarizedCounterBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Max", targetDepth)) {
                    context.nextToken();
                    summarizedCounterBuilder.max((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Average", targetDepth)) {
                    context.nextToken();
                    summarizedCounterBuilder.average((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Sum", targetDepth)) {
                    context.nextToken();
                    summarizedCounterBuilder.sum((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("N", targetDepth)) {
                    context.nextToken();
                    summarizedCounterBuilder.n((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Unit", targetDepth)) {
                    context.nextToken();
                    summarizedCounterBuilder.unit((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SummarizedCounter)summarizedCounterBuilder.build();
    }

    public static SummarizedCounterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

