/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.transform.SummarizedCounterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SummarizedCounter
implements StructuredPojo,
ToCopyableBuilder<Builder, SummarizedCounter> {
    private final String name;
    private final Double max;
    private final Double average;
    private final Double sum;
    private final Integer n;
    private final String unit;

    private SummarizedCounter(BuilderImpl builder) {
        this.name = builder.name;
        this.max = builder.max;
        this.average = builder.average;
        this.sum = builder.sum;
        this.n = builder.n;
        this.unit = builder.unit;
    }

    public String name() {
        return this.name;
    }

    public Double max() {
        return this.max;
    }

    public Double average() {
        return this.average;
    }

    public Double sum() {
        return this.sum;
    }

    public Integer n() {
        return this.n;
    }

    public String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.max());
        hashCode = 31 * hashCode + Objects.hashCode(this.average());
        hashCode = 31 * hashCode + Objects.hashCode(this.sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.n());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummarizedCounter)) {
            return false;
        }
        SummarizedCounter other = (SummarizedCounter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.max(), other.max()) && Objects.equals(this.average(), other.average()) && Objects.equals(this.sum(), other.sum()) && Objects.equals(this.n(), other.n()) && Objects.equals(this.unit(), other.unit());
    }

    public String toString() {
        return ToString.builder((String)"SummarizedCounter").add("Name", (Object)this.name()).add("Max", (Object)this.max()).add("Average", (Object)this.average()).add("Sum", (Object)this.sum()).add("N", (Object)this.n()).add("Unit", (Object)this.unit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Max": {
                return Optional.of(clazz.cast(this.max()));
            }
            case "Average": {
                return Optional.of(clazz.cast(this.average()));
            }
            case "Sum": {
                return Optional.of(clazz.cast(this.sum()));
            }
            case "N": {
                return Optional.of(clazz.cast(this.n()));
            }
            case "Unit": {
                return Optional.of(clazz.cast(this.unit()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SummarizedCounterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Double max;
        private Double average;
        private Double sum;
        private Integer n;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(SummarizedCounter model) {
            this.name(model.name);
            this.max(model.max);
            this.average(model.average);
            this.sum(model.sum);
            this.n(model.n);
            this.unit(model.unit);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Double getMax() {
            return this.max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        public final Double getAverage() {
            return this.average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getSum() {
            return this.sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Integer getN() {
            return this.n;
        }

        @Override
        public final Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public final void setN(Integer n) {
            this.n = n;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public SummarizedCounter build() {
            return new SummarizedCounter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SummarizedCounter> {
        public Builder name(String var1);

        public Builder max(Double var1);

        public Builder average(Double var1);

        public Builder sum(Double var1);

        public Builder n(Integer var1);

        public Builder unit(String var1);
    }
}

