/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.transform.SubscriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Subscription
implements StructuredPojo,
ToCopyableBuilder<Builder, Subscription> {
    private final Instant startTime;
    private final Long timeCommitmentInSeconds;

    private Subscription(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.timeCommitmentInSeconds = builder.timeCommitmentInSeconds;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Long timeCommitmentInSeconds() {
        return this.timeCommitmentInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeCommitmentInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.timeCommitmentInSeconds(), other.timeCommitmentInSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.timeCommitmentInSeconds() != null) {
            sb.append("TimeCommitmentInSeconds: ").append(this.timeCommitmentInSeconds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "TimeCommitmentInSeconds": {
                return Optional.of(clazz.cast(this.timeCommitmentInSeconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startTime;
        private Long timeCommitmentInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.startTime(model.startTime);
            this.timeCommitmentInSeconds(model.timeCommitmentInSeconds);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Long getTimeCommitmentInSeconds() {
            return this.timeCommitmentInSeconds;
        }

        @Override
        public final Builder timeCommitmentInSeconds(Long timeCommitmentInSeconds) {
            this.timeCommitmentInSeconds = timeCommitmentInSeconds;
            return this;
        }

        public final void setTimeCommitmentInSeconds(Long timeCommitmentInSeconds) {
            this.timeCommitmentInSeconds = timeCommitmentInSeconds;
        }

        public Subscription build() {
            return new Subscription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subscription> {
        public Builder startTime(Instant var1);

        public Builder timeCommitmentInSeconds(Long var1);
    }
}

