/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.model.AttackVectorDescription;
import software.amazon.awssdk.services.shield.model.AttackVectorDescriptionListCopier;
import software.amazon.awssdk.services.shield.transform.AttackSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttackSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, AttackSummary> {
    private final String attackId;
    private final String resourceArn;
    private final Instant startTime;
    private final Instant endTime;
    private final List<AttackVectorDescription> attackVectors;

    private AttackSummary(BuilderImpl builder) {
        this.attackId = builder.attackId;
        this.resourceArn = builder.resourceArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.attackVectors = builder.attackVectors;
    }

    public String attackId() {
        return this.attackId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public List<AttackVectorDescription> attackVectors() {
        return this.attackVectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attackId() == null ? 0 : this.attackId().hashCode());
        hashCode = 31 * hashCode + (this.resourceArn() == null ? 0 : this.resourceArn().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.attackVectors() == null ? 0 : this.attackVectors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackSummary)) {
            return false;
        }
        AttackSummary other = (AttackSummary)obj;
        if (other.attackId() == null ^ this.attackId() == null) {
            return false;
        }
        if (other.attackId() != null && !other.attackId().equals(this.attackId())) {
            return false;
        }
        if (other.resourceArn() == null ^ this.resourceArn() == null) {
            return false;
        }
        if (other.resourceArn() != null && !other.resourceArn().equals(this.resourceArn())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.attackVectors() == null ^ this.attackVectors() == null) {
            return false;
        }
        return other.attackVectors() == null || other.attackVectors().equals(this.attackVectors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attackId() != null) {
            sb.append("AttackId: ").append(this.attackId()).append(",");
        }
        if (this.resourceArn() != null) {
            sb.append("ResourceArn: ").append(this.resourceArn()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.attackVectors() != null) {
            sb.append("AttackVectors: ").append(this.attackVectors()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttackId": {
                return Optional.of(clazz.cast(this.attackId()));
            }
            case "ResourceArn": {
                return Optional.of(clazz.cast(this.resourceArn()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "AttackVectors": {
                return Optional.of(clazz.cast(this.attackVectors()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttackSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attackId;
        private String resourceArn;
        private Instant startTime;
        private Instant endTime;
        private List<AttackVectorDescription> attackVectors;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackSummary model) {
            this.attackId(model.attackId);
            this.resourceArn(model.resourceArn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.attackVectors(model.attackVectors);
        }

        public final String getAttackId() {
            return this.attackId;
        }

        @Override
        public final Builder attackId(String attackId) {
            this.attackId = attackId;
            return this;
        }

        public final void setAttackId(String attackId) {
            this.attackId = attackId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<AttackVectorDescription.Builder> getAttackVectors() {
            return this.attackVectors != null ? (Collection)this.attackVectors.stream().map(AttackVectorDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attackVectors(Collection<AttackVectorDescription> attackVectors) {
            this.attackVectors = AttackVectorDescriptionListCopier.copy(attackVectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(AttackVectorDescription ... attackVectors) {
            this.attackVectors(Arrays.asList(attackVectors));
            return this;
        }

        public final void setAttackVectors(Collection<AttackVectorDescription.BuilderImpl> attackVectors) {
            this.attackVectors = AttackVectorDescriptionListCopier.copyFromBuilder(attackVectors);
        }

        public AttackSummary build() {
            return new AttackSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttackSummary> {
        public Builder attackId(String var1);

        public Builder resourceArn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder attackVectors(Collection<AttackVectorDescription> var1);

        public Builder attackVectors(AttackVectorDescription ... var1);
    }
}

