/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;

@SdkInternalApi
public class SummarizedCounterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Double> MAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Max").build();
    private static final MarshallingInfo<Double> AVERAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Average").build();
    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sum").build();
    private static final MarshallingInfo<Integer> N_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("N").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").build();
    private static final SummarizedCounterMarshaller INSTANCE = new SummarizedCounterMarshaller();

    public static SummarizedCounterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SummarizedCounter summarizedCounter, ProtocolMarshaller protocolMarshaller) {
        if (summarizedCounter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)summarizedCounter.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)summarizedCounter.max(), MAX_BINDING);
            protocolMarshaller.marshall((Object)summarizedCounter.average(), AVERAGE_BINDING);
            protocolMarshaller.marshall((Object)summarizedCounter.sum(), SUM_BINDING);
            protocolMarshaller.marshall((Object)summarizedCounter.n(), N_BINDING);
            protocolMarshaller.marshall((Object)summarizedCounter.unit(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

