/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.Subscription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubscriptionMarshaller {
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<Long> TIMECOMMITMENTINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeCommitmentInSeconds").isBinary(false).build();
    private static final MarshallingInfo<String> AUTORENEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoRenew").isBinary(false).build();
    private static final MarshallingInfo<List> LIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limits").isBinary(false).build();
    private static final SubscriptionMarshaller INSTANCE = new SubscriptionMarshaller();

    private SubscriptionMarshaller() {
    }

    public static SubscriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Subscription subscription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)subscription, (String)"subscription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)subscription.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)subscription.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)subscription.timeCommitmentInSeconds(), TIMECOMMITMENTINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)subscription.autoRenewAsString(), AUTORENEW_BINDING);
            protocolMarshaller.marshall(subscription.limits(), LIMITS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

