/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.shield.model.GetSubscriptionStateRequest;
import software.amazon.awssdk.services.shield.transform.GetSubscriptionStateRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetSubscriptionStateRequestMarshaller
implements Marshaller<Request<GetSubscriptionStateRequest>, GetSubscriptionStateRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(false).operationIdentifier("AWSShield_20160616.GetSubscriptionState").serviceName("AWS Shield").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public GetSubscriptionStateRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetSubscriptionStateRequest> marshall(GetSubscriptionStateRequest getSubscriptionStateRequest) {
        Validate.paramNotNull((Object)((Object)getSubscriptionStateRequest), (String)"getSubscriptionStateRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)getSubscriptionStateRequest);
            protocolMarshaller.startMarshalling();
            GetSubscriptionStateRequestModelMarshaller.getInstance().marshall(getSubscriptionStateRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

