/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.EmergencyContact;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EmergencyContactMarshaller {
    private static final MarshallingInfo<String> EMAILADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailAddress").isBinary(false).build();
    private static final EmergencyContactMarshaller INSTANCE = new EmergencyContactMarshaller();

    private EmergencyContactMarshaller() {
    }

    public static EmergencyContactMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EmergencyContact emergencyContact, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)emergencyContact, (String)"emergencyContact");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)emergencyContact.emailAddress(), EMAILADDRESS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

