/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.transform.LimitMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Limit
implements StructuredPojo,
ToCopyableBuilder<Builder, Limit> {
    private final String type;
    private final Long max;

    private Limit(BuilderImpl builder) {
        this.type = builder.type;
        this.max = builder.max;
    }

    public String type() {
        return this.type;
    }

    public Long max() {
        return this.max;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.max());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Limit)) {
            return false;
        }
        Limit other = (Limit)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.max(), other.max());
    }

    public String toString() {
        return ToString.builder((String)"Limit").add("Type", (Object)this.type()).add("Max", (Object)this.max()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Max": {
                return Optional.ofNullable(clazz.cast(this.max()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LimitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Long max;

        private BuilderImpl() {
        }

        private BuilderImpl(Limit model) {
            this.type(model.type);
            this.max(model.max);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getMax() {
            return this.max;
        }

        @Override
        public final Builder max(Long max) {
            this.max = max;
            return this;
        }

        public final void setMax(Long max) {
            this.max = max;
        }

        public Limit build() {
            return new Limit(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Limit> {
        public Builder type(String var1);

        public Builder max(Long var1);
    }
}

