/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.EmergencyContact;
import software.amazon.awssdk.services.shield.model.EmergencyContactListCopier;
import software.amazon.awssdk.services.shield.model.ShieldResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEmergencyContactSettingsResponse
extends ShieldResponse
implements ToCopyableBuilder<Builder, DescribeEmergencyContactSettingsResponse> {
    private final List<EmergencyContact> emergencyContactList;

    private DescribeEmergencyContactSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.emergencyContactList = builder.emergencyContactList;
    }

    public List<EmergencyContact> emergencyContactList() {
        return this.emergencyContactList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emergencyContactList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEmergencyContactSettingsResponse)) {
            return false;
        }
        DescribeEmergencyContactSettingsResponse other = (DescribeEmergencyContactSettingsResponse)((Object)obj);
        return Objects.equals(this.emergencyContactList(), other.emergencyContactList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEmergencyContactSettingsResponse").add("EmergencyContactList", this.emergencyContactList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmergencyContactList": {
                return Optional.ofNullable(clazz.cast(this.emergencyContactList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ShieldResponse.BuilderImpl
    implements Builder {
        private List<EmergencyContact> emergencyContactList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEmergencyContactSettingsResponse model) {
            super(model);
            this.emergencyContactList(model.emergencyContactList);
        }

        public final Collection<EmergencyContact.Builder> getEmergencyContactList() {
            return this.emergencyContactList != null ? (Collection)this.emergencyContactList.stream().map(EmergencyContact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder emergencyContactList(Collection<EmergencyContact> emergencyContactList) {
            this.emergencyContactList = EmergencyContactListCopier.copy(emergencyContactList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emergencyContactList(EmergencyContact ... emergencyContactList) {
            this.emergencyContactList(Arrays.asList(emergencyContactList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emergencyContactList(Consumer<EmergencyContact.Builder> ... emergencyContactList) {
            this.emergencyContactList(Stream.of(emergencyContactList).map(c -> (EmergencyContact)((EmergencyContact.Builder)EmergencyContact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEmergencyContactList(Collection<EmergencyContact.BuilderImpl> emergencyContactList) {
            this.emergencyContactList = EmergencyContactListCopier.copyFromBuilder(emergencyContactList);
        }

        @Override
        public DescribeEmergencyContactSettingsResponse build() {
            return new DescribeEmergencyContactSettingsResponse(this);
        }
    }

    public static interface Builder
    extends ShieldResponse.Builder,
    CopyableBuilder<Builder, DescribeEmergencyContactSettingsResponse> {
        public Builder emergencyContactList(Collection<EmergencyContact> var1);

        public Builder emergencyContactList(EmergencyContact ... var1);

        public Builder emergencyContactList(Consumer<EmergencyContact.Builder> ... var1);
    }
}

