/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.AttackDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttackDetailMarshaller {
    private static final MarshallingInfo<String> ATTACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").isBinary(false).build();
    private static final MarshallingInfo<List> SUBRESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubResources").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<List> ATTACKCOUNTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackCounters").isBinary(false).build();
    private static final MarshallingInfo<List> MITIGATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mitigations").isBinary(false).build();
    private static final AttackDetailMarshaller INSTANCE = new AttackDetailMarshaller();

    private AttackDetailMarshaller() {
    }

    public static AttackDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttackDetail attackDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)attackDetail, (String)"attackDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attackDetail.attackId(), ATTACKID_BINDING);
            protocolMarshaller.marshall((Object)attackDetail.resourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall(attackDetail.subResources(), SUBRESOURCES_BINDING);
            protocolMarshaller.marshall((Object)attackDetail.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)attackDetail.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(attackDetail.attackCounters(), ATTACKCOUNTERS_BINDING);
            protocolMarshaller.marshall(attackDetail.mitigations(), MITIGATIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

