/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;
import software.amazon.awssdk.services.shield.model.SummarizedCounterListCopier;
import software.amazon.awssdk.services.shield.transform.SummarizedAttackVectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SummarizedAttackVector
implements StructuredPojo,
ToCopyableBuilder<Builder, SummarizedAttackVector> {
    private final String vectorType;
    private final List<SummarizedCounter> vectorCounters;

    private SummarizedAttackVector(BuilderImpl builder) {
        this.vectorType = builder.vectorType;
        this.vectorCounters = builder.vectorCounters;
    }

    public String vectorType() {
        return this.vectorType;
    }

    public List<SummarizedCounter> vectorCounters() {
        return this.vectorCounters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorType());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorCounters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummarizedAttackVector)) {
            return false;
        }
        SummarizedAttackVector other = (SummarizedAttackVector)obj;
        return Objects.equals(this.vectorType(), other.vectorType()) && Objects.equals(this.vectorCounters(), other.vectorCounters());
    }

    public String toString() {
        return ToString.builder((String)"SummarizedAttackVector").add("VectorType", (Object)this.vectorType()).add("VectorCounters", this.vectorCounters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VectorType": {
                return Optional.ofNullable(clazz.cast(this.vectorType()));
            }
            case "VectorCounters": {
                return Optional.ofNullable(clazz.cast(this.vectorCounters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SummarizedAttackVectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String vectorType;
        private List<SummarizedCounter> vectorCounters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SummarizedAttackVector model) {
            this.vectorType(model.vectorType);
            this.vectorCounters(model.vectorCounters);
        }

        public final String getVectorType() {
            return this.vectorType;
        }

        @Override
        public final Builder vectorType(String vectorType) {
            this.vectorType = vectorType;
            return this;
        }

        public final void setVectorType(String vectorType) {
            this.vectorType = vectorType;
        }

        public final Collection<SummarizedCounter.Builder> getVectorCounters() {
            return this.vectorCounters != null ? (Collection)this.vectorCounters.stream().map(SummarizedCounter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vectorCounters(Collection<SummarizedCounter> vectorCounters) {
            this.vectorCounters = SummarizedCounterListCopier.copy(vectorCounters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorCounters(SummarizedCounter ... vectorCounters) {
            this.vectorCounters(Arrays.asList(vectorCounters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorCounters(Consumer<SummarizedCounter.Builder> ... vectorCounters) {
            this.vectorCounters(Stream.of(vectorCounters).map(c -> (SummarizedCounter)((SummarizedCounter.Builder)SummarizedCounter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVectorCounters(Collection<SummarizedCounter.BuilderImpl> vectorCounters) {
            this.vectorCounters = SummarizedCounterListCopier.copyFromBuilder(vectorCounters);
        }

        public SummarizedAttackVector build() {
            return new SummarizedAttackVector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SummarizedAttackVector> {
        public Builder vectorType(String var1);

        public Builder vectorCounters(Collection<SummarizedCounter> var1);

        public Builder vectorCounters(SummarizedCounter ... var1);

        public Builder vectorCounters(Consumer<SummarizedCounter.Builder> ... var1);
    }
}

