/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.TimeRange;

@SdkInternalApi
public class TimeRangeMarshaller {
    private static final MarshallingInfo<Date> FROMINCLUSIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromInclusive").build();
    private static final MarshallingInfo<Date> TOEXCLUSIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ToExclusive").build();
    private static final TimeRangeMarshaller instance = new TimeRangeMarshaller();

    public static TimeRangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(TimeRange timeRange, ProtocolMarshaller protocolMarshaller) {
        if (timeRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)timeRange.fromInclusive(), FROMINCLUSIVE_BINDING);
            protocolMarshaller.marshall((Object)timeRange.toExclusive(), TOEXCLUSIVE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

