/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.SummarizedAttackVector;

@SdkInternalApi
public class SummarizedAttackVectorMarshaller {
    private static final MarshallingInfo<String> VECTORTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VectorType").build();
    private static final MarshallingInfo<List> VECTORCOUNTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VectorCounters").build();
    private static final SummarizedAttackVectorMarshaller instance = new SummarizedAttackVectorMarshaller();

    public static SummarizedAttackVectorMarshaller getInstance() {
        return instance;
    }

    public void marshall(SummarizedAttackVector summarizedAttackVector, ProtocolMarshaller protocolMarshaller) {
        if (summarizedAttackVector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)summarizedAttackVector.vectorType(), VECTORTYPE_BINDING);
            protocolMarshaller.marshall(summarizedAttackVector.vectorCounters(), VECTORCOUNTERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

