/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.transform.SummarizedCounterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SummarizedCounter
implements StructuredPojo,
ToCopyableBuilder<Builder, SummarizedCounter> {
    private final String name;
    private final Double max;
    private final Double average;
    private final Double sum;
    private final Integer n;
    private final String unit;

    private SummarizedCounter(BuilderImpl builder) {
        this.name = builder.name;
        this.max = builder.max;
        this.average = builder.average;
        this.sum = builder.sum;
        this.n = builder.n;
        this.unit = builder.unit;
    }

    public String name() {
        return this.name;
    }

    public Double max() {
        return this.max;
    }

    public Double average() {
        return this.average;
    }

    public Double sum() {
        return this.sum;
    }

    public Integer n() {
        return this.n;
    }

    public String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.max() == null ? 0 : this.max().hashCode());
        hashCode = 31 * hashCode + (this.average() == null ? 0 : this.average().hashCode());
        hashCode = 31 * hashCode + (this.sum() == null ? 0 : this.sum().hashCode());
        hashCode = 31 * hashCode + (this.n() == null ? 0 : this.n().hashCode());
        hashCode = 31 * hashCode + (this.unit() == null ? 0 : this.unit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummarizedCounter)) {
            return false;
        }
        SummarizedCounter other = (SummarizedCounter)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.max() == null ^ this.max() == null) {
            return false;
        }
        if (other.max() != null && !other.max().equals(this.max())) {
            return false;
        }
        if (other.average() == null ^ this.average() == null) {
            return false;
        }
        if (other.average() != null && !other.average().equals(this.average())) {
            return false;
        }
        if (other.sum() == null ^ this.sum() == null) {
            return false;
        }
        if (other.sum() != null && !other.sum().equals(this.sum())) {
            return false;
        }
        if (other.n() == null ^ this.n() == null) {
            return false;
        }
        if (other.n() != null && !other.n().equals(this.n())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        return other.unit() == null || other.unit().equals(this.unit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.max() != null) {
            sb.append("Max: ").append(this.max()).append(",");
        }
        if (this.average() != null) {
            sb.append("Average: ").append(this.average()).append(",");
        }
        if (this.sum() != null) {
            sb.append("Sum: ").append(this.sum()).append(",");
        }
        if (this.n() != null) {
            sb.append("N: ").append(this.n()).append(",");
        }
        if (this.unit() != null) {
            sb.append("Unit: ").append(this.unit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SummarizedCounterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private Double max;
        private Double average;
        private Double sum;
        private Integer n;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(SummarizedCounter model) {
            this.setName(model.name);
            this.setMax(model.max);
            this.setAverage(model.average);
            this.setSum(model.sum);
            this.setN(model.n);
            this.setUnit(model.unit);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Double getMax() {
            return this.max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        public final Double getAverage() {
            return this.average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getSum() {
            return this.sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Integer getN() {
            return this.n;
        }

        @Override
        public final Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public final void setN(Integer n) {
            this.n = n;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public SummarizedCounter build() {
            return new SummarizedCounter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SummarizedCounter> {
        public Builder name(String var1);

        public Builder max(Double var1);

        public Builder average(Double var1);

        public Builder sum(Double var1);

        public Builder n(Integer var1);

        public Builder unit(String var1);
    }
}

