/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.shield.model.ResourceArnFilterListCopier;
import software.amazon.awssdk.services.shield.model.TimeRange;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAttacksRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListAttacksRequest> {
    private final List<String> resourceArns;
    private final TimeRange startTime;
    private final TimeRange endTime;
    private final String nextToken;
    private final Integer maxResults;

    private ListAttacksRequest(BuilderImpl builder) {
        this.resourceArns = builder.resourceArns;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> resourceArns() {
        return this.resourceArns;
    }

    public TimeRange startTime() {
        return this.startTime;
    }

    public TimeRange endTime() {
        return this.endTime;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceArns() == null ? 0 : this.resourceArns().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttacksRequest)) {
            return false;
        }
        ListAttacksRequest other = (ListAttacksRequest)((Object)obj);
        if (other.resourceArns() == null ^ this.resourceArns() == null) {
            return false;
        }
        if (other.resourceArns() != null && !other.resourceArns().equals(this.resourceArns())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceArns() != null) {
            sb.append("ResourceArns: ").append(this.resourceArns()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> resourceArns;
        private TimeRange startTime;
        private TimeRange endTime;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttacksRequest model) {
            this.setResourceArns(model.resourceArns);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setNextToken(model.nextToken);
            this.setMaxResults(model.maxResults);
        }

        public final Collection<String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnFilterListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            if (this.resourceArns == null) {
                this.resourceArns = new ArrayList<String>(resourceArns.length);
            }
            for (String e : resourceArns) {
                this.resourceArns.add(e);
            }
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnFilterListCopier.copy(resourceArns);
        }

        @SafeVarargs
        public final void setResourceArns(String ... resourceArns) {
            if (this.resourceArns == null) {
                this.resourceArns = new ArrayList<String>(resourceArns.length);
            }
            for (String e : resourceArns) {
                this.resourceArns.add(e);
            }
        }

        public final TimeRange getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(TimeRange startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(TimeRange startTime) {
            this.startTime = startTime;
        }

        public final TimeRange getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(TimeRange endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(TimeRange endTime) {
            this.endTime = endTime;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public ListAttacksRequest build() {
            return new ListAttacksRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAttacksRequest> {
        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder startTime(TimeRange var1);

        public Builder endTime(TimeRange var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

