/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStateMachineForExecutionResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, DescribeStateMachineForExecutionResponse> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::stateMachineArn)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::name)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::definition)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::roleArn)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::updateDate)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD, NAME_FIELD, DEFINITION_FIELD, ROLE_ARN_FIELD, UPDATE_DATE_FIELD));
    private final String stateMachineArn;
    private final String name;
    private final String definition;
    private final String roleArn;
    private final Instant updateDate;

    private DescribeStateMachineForExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.updateDate = builder.updateDate;
    }

    public String stateMachineArn() {
        return this.stateMachineArn;
    }

    public String name() {
        return this.name;
    }

    public String definition() {
        return this.definition;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStateMachineForExecutionResponse)) {
            return false;
        }
        DescribeStateMachineForExecutionResponse other = (DescribeStateMachineForExecutionResponse)((Object)obj);
        return Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.updateDate(), other.updateDate());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStateMachineForExecutionResponse").add("StateMachineArn", (Object)this.stateMachineArn()).add("Name", (Object)this.name()).add("Definition", (Object)(this.definition() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleArn", (Object)this.roleArn()).add("UpdateDate", (Object)this.updateDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "updateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStateMachineForExecutionResponse, T> g) {
        return obj -> g.apply((DescribeStateMachineForExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String stateMachineArn;
        private String name;
        private String definition;
        private String roleArn;
        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStateMachineForExecutionResponse model) {
            super(model);
            this.stateMachineArn(model.stateMachineArn);
            this.name(model.name);
            this.definition(model.definition);
            this.roleArn(model.roleArn);
            this.updateDate(model.updateDate);
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDefinition() {
            return this.definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public DescribeStateMachineForExecutionResponse build() {
            return new DescribeStateMachineForExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStateMachineForExecutionResponse> {
        public Builder stateMachineArn(String var1);

        public Builder name(String var1);

        public Builder definition(String var1);

        public Builder roleArn(String var1);

        public Builder updateDate(Instant var1);
    }
}

