/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.ActivityFailedEventDetails;
import software.amazon.awssdk.services.sfn.model.ActivityScheduleFailedEventDetails;
import software.amazon.awssdk.services.sfn.model.ActivityScheduledEventDetails;
import software.amazon.awssdk.services.sfn.model.ActivityStartedEventDetails;
import software.amazon.awssdk.services.sfn.model.ActivitySucceededEventDetails;
import software.amazon.awssdk.services.sfn.model.ActivityTimedOutEventDetails;
import software.amazon.awssdk.services.sfn.model.ExecutionAbortedEventDetails;
import software.amazon.awssdk.services.sfn.model.ExecutionFailedEventDetails;
import software.amazon.awssdk.services.sfn.model.ExecutionStartedEventDetails;
import software.amazon.awssdk.services.sfn.model.ExecutionSucceededEventDetails;
import software.amazon.awssdk.services.sfn.model.ExecutionTimedOutEventDetails;
import software.amazon.awssdk.services.sfn.model.HistoryEventType;
import software.amazon.awssdk.services.sfn.model.LambdaFunctionFailedEventDetails;
import software.amazon.awssdk.services.sfn.model.LambdaFunctionScheduleFailedEventDetails;
import software.amazon.awssdk.services.sfn.model.LambdaFunctionScheduledEventDetails;
import software.amazon.awssdk.services.sfn.model.LambdaFunctionStartFailedEventDetails;
import software.amazon.awssdk.services.sfn.model.LambdaFunctionSucceededEventDetails;
import software.amazon.awssdk.services.sfn.model.LambdaFunctionTimedOutEventDetails;
import software.amazon.awssdk.services.sfn.model.StateEnteredEventDetails;
import software.amazon.awssdk.services.sfn.model.StateExitedEventDetails;
import software.amazon.awssdk.services.sfn.model.TaskFailedEventDetails;
import software.amazon.awssdk.services.sfn.model.TaskScheduledEventDetails;
import software.amazon.awssdk.services.sfn.model.TaskStartFailedEventDetails;
import software.amazon.awssdk.services.sfn.model.TaskStartedEventDetails;
import software.amazon.awssdk.services.sfn.model.TaskSubmitFailedEventDetails;
import software.amazon.awssdk.services.sfn.model.TaskSubmittedEventDetails;
import software.amazon.awssdk.services.sfn.model.TaskSucceededEventDetails;
import software.amazon.awssdk.services.sfn.model.TaskTimedOutEventDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HistoryEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HistoryEvent> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(HistoryEvent.getter(HistoryEvent::timestamp)).setter(HistoryEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HistoryEvent.getter(HistoryEvent::typeAsString)).setter(HistoryEvent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Long> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(HistoryEvent.getter(HistoryEvent::id)).setter(HistoryEvent.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Long> PREVIOUS_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(HistoryEvent.getter(HistoryEvent::previousEventId)).setter(HistoryEvent.setter(Builder::previousEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousEventId").build()}).build();
    private static final SdkField<ActivityFailedEventDetails> ACTIVITY_FAILED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::activityFailedEventDetails)).setter(HistoryEvent.setter(Builder::activityFailedEventDetails)).constructor(ActivityFailedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityFailedEventDetails").build()}).build();
    private static final SdkField<ActivityScheduleFailedEventDetails> ACTIVITY_SCHEDULE_FAILED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::activityScheduleFailedEventDetails)).setter(HistoryEvent.setter(Builder::activityScheduleFailedEventDetails)).constructor(ActivityScheduleFailedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityScheduleFailedEventDetails").build()}).build();
    private static final SdkField<ActivityScheduledEventDetails> ACTIVITY_SCHEDULED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::activityScheduledEventDetails)).setter(HistoryEvent.setter(Builder::activityScheduledEventDetails)).constructor(ActivityScheduledEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityScheduledEventDetails").build()}).build();
    private static final SdkField<ActivityStartedEventDetails> ACTIVITY_STARTED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::activityStartedEventDetails)).setter(HistoryEvent.setter(Builder::activityStartedEventDetails)).constructor(ActivityStartedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityStartedEventDetails").build()}).build();
    private static final SdkField<ActivitySucceededEventDetails> ACTIVITY_SUCCEEDED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::activitySucceededEventDetails)).setter(HistoryEvent.setter(Builder::activitySucceededEventDetails)).constructor(ActivitySucceededEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activitySucceededEventDetails").build()}).build();
    private static final SdkField<ActivityTimedOutEventDetails> ACTIVITY_TIMED_OUT_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::activityTimedOutEventDetails)).setter(HistoryEvent.setter(Builder::activityTimedOutEventDetails)).constructor(ActivityTimedOutEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityTimedOutEventDetails").build()}).build();
    private static final SdkField<TaskFailedEventDetails> TASK_FAILED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::taskFailedEventDetails)).setter(HistoryEvent.setter(Builder::taskFailedEventDetails)).constructor(TaskFailedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskFailedEventDetails").build()}).build();
    private static final SdkField<TaskScheduledEventDetails> TASK_SCHEDULED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::taskScheduledEventDetails)).setter(HistoryEvent.setter(Builder::taskScheduledEventDetails)).constructor(TaskScheduledEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskScheduledEventDetails").build()}).build();
    private static final SdkField<TaskStartFailedEventDetails> TASK_START_FAILED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::taskStartFailedEventDetails)).setter(HistoryEvent.setter(Builder::taskStartFailedEventDetails)).constructor(TaskStartFailedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartFailedEventDetails").build()}).build();
    private static final SdkField<TaskStartedEventDetails> TASK_STARTED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::taskStartedEventDetails)).setter(HistoryEvent.setter(Builder::taskStartedEventDetails)).constructor(TaskStartedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartedEventDetails").build()}).build();
    private static final SdkField<TaskSubmitFailedEventDetails> TASK_SUBMIT_FAILED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::taskSubmitFailedEventDetails)).setter(HistoryEvent.setter(Builder::taskSubmitFailedEventDetails)).constructor(TaskSubmitFailedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSubmitFailedEventDetails").build()}).build();
    private static final SdkField<TaskSubmittedEventDetails> TASK_SUBMITTED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::taskSubmittedEventDetails)).setter(HistoryEvent.setter(Builder::taskSubmittedEventDetails)).constructor(TaskSubmittedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSubmittedEventDetails").build()}).build();
    private static final SdkField<TaskSucceededEventDetails> TASK_SUCCEEDED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::taskSucceededEventDetails)).setter(HistoryEvent.setter(Builder::taskSucceededEventDetails)).constructor(TaskSucceededEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSucceededEventDetails").build()}).build();
    private static final SdkField<TaskTimedOutEventDetails> TASK_TIMED_OUT_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::taskTimedOutEventDetails)).setter(HistoryEvent.setter(Builder::taskTimedOutEventDetails)).constructor(TaskTimedOutEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskTimedOutEventDetails").build()}).build();
    private static final SdkField<ExecutionFailedEventDetails> EXECUTION_FAILED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::executionFailedEventDetails)).setter(HistoryEvent.setter(Builder::executionFailedEventDetails)).constructor(ExecutionFailedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionFailedEventDetails").build()}).build();
    private static final SdkField<ExecutionStartedEventDetails> EXECUTION_STARTED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::executionStartedEventDetails)).setter(HistoryEvent.setter(Builder::executionStartedEventDetails)).constructor(ExecutionStartedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartedEventDetails").build()}).build();
    private static final SdkField<ExecutionSucceededEventDetails> EXECUTION_SUCCEEDED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::executionSucceededEventDetails)).setter(HistoryEvent.setter(Builder::executionSucceededEventDetails)).constructor(ExecutionSucceededEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionSucceededEventDetails").build()}).build();
    private static final SdkField<ExecutionAbortedEventDetails> EXECUTION_ABORTED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::executionAbortedEventDetails)).setter(HistoryEvent.setter(Builder::executionAbortedEventDetails)).constructor(ExecutionAbortedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionAbortedEventDetails").build()}).build();
    private static final SdkField<ExecutionTimedOutEventDetails> EXECUTION_TIMED_OUT_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::executionTimedOutEventDetails)).setter(HistoryEvent.setter(Builder::executionTimedOutEventDetails)).constructor(ExecutionTimedOutEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimedOutEventDetails").build()}).build();
    private static final SdkField<LambdaFunctionFailedEventDetails> LAMBDA_FUNCTION_FAILED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::lambdaFunctionFailedEventDetails)).setter(HistoryEvent.setter(Builder::lambdaFunctionFailedEventDetails)).constructor(LambdaFunctionFailedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionFailedEventDetails").build()}).build();
    private static final SdkField<LambdaFunctionScheduleFailedEventDetails> LAMBDA_FUNCTION_SCHEDULE_FAILED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::lambdaFunctionScheduleFailedEventDetails)).setter(HistoryEvent.setter(Builder::lambdaFunctionScheduleFailedEventDetails)).constructor(LambdaFunctionScheduleFailedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionScheduleFailedEventDetails").build()}).build();
    private static final SdkField<LambdaFunctionScheduledEventDetails> LAMBDA_FUNCTION_SCHEDULED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::lambdaFunctionScheduledEventDetails)).setter(HistoryEvent.setter(Builder::lambdaFunctionScheduledEventDetails)).constructor(LambdaFunctionScheduledEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionScheduledEventDetails").build()}).build();
    private static final SdkField<LambdaFunctionStartFailedEventDetails> LAMBDA_FUNCTION_START_FAILED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::lambdaFunctionStartFailedEventDetails)).setter(HistoryEvent.setter(Builder::lambdaFunctionStartFailedEventDetails)).constructor(LambdaFunctionStartFailedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionStartFailedEventDetails").build()}).build();
    private static final SdkField<LambdaFunctionSucceededEventDetails> LAMBDA_FUNCTION_SUCCEEDED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::lambdaFunctionSucceededEventDetails)).setter(HistoryEvent.setter(Builder::lambdaFunctionSucceededEventDetails)).constructor(LambdaFunctionSucceededEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionSucceededEventDetails").build()}).build();
    private static final SdkField<LambdaFunctionTimedOutEventDetails> LAMBDA_FUNCTION_TIMED_OUT_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::lambdaFunctionTimedOutEventDetails)).setter(HistoryEvent.setter(Builder::lambdaFunctionTimedOutEventDetails)).constructor(LambdaFunctionTimedOutEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionTimedOutEventDetails").build()}).build();
    private static final SdkField<StateEnteredEventDetails> STATE_ENTERED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::stateEnteredEventDetails)).setter(HistoryEvent.setter(Builder::stateEnteredEventDetails)).constructor(StateEnteredEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateEnteredEventDetails").build()}).build();
    private static final SdkField<StateExitedEventDetails> STATE_EXITED_EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryEvent.getter(HistoryEvent::stateExitedEventDetails)).setter(HistoryEvent.setter(Builder::stateExitedEventDetails)).constructor(StateExitedEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateExitedEventDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, TYPE_FIELD, ID_FIELD, PREVIOUS_EVENT_ID_FIELD, ACTIVITY_FAILED_EVENT_DETAILS_FIELD, ACTIVITY_SCHEDULE_FAILED_EVENT_DETAILS_FIELD, ACTIVITY_SCHEDULED_EVENT_DETAILS_FIELD, ACTIVITY_STARTED_EVENT_DETAILS_FIELD, ACTIVITY_SUCCEEDED_EVENT_DETAILS_FIELD, ACTIVITY_TIMED_OUT_EVENT_DETAILS_FIELD, TASK_FAILED_EVENT_DETAILS_FIELD, TASK_SCHEDULED_EVENT_DETAILS_FIELD, TASK_START_FAILED_EVENT_DETAILS_FIELD, TASK_STARTED_EVENT_DETAILS_FIELD, TASK_SUBMIT_FAILED_EVENT_DETAILS_FIELD, TASK_SUBMITTED_EVENT_DETAILS_FIELD, TASK_SUCCEEDED_EVENT_DETAILS_FIELD, TASK_TIMED_OUT_EVENT_DETAILS_FIELD, EXECUTION_FAILED_EVENT_DETAILS_FIELD, EXECUTION_STARTED_EVENT_DETAILS_FIELD, EXECUTION_SUCCEEDED_EVENT_DETAILS_FIELD, EXECUTION_ABORTED_EVENT_DETAILS_FIELD, EXECUTION_TIMED_OUT_EVENT_DETAILS_FIELD, LAMBDA_FUNCTION_FAILED_EVENT_DETAILS_FIELD, LAMBDA_FUNCTION_SCHEDULE_FAILED_EVENT_DETAILS_FIELD, LAMBDA_FUNCTION_SCHEDULED_EVENT_DETAILS_FIELD, LAMBDA_FUNCTION_START_FAILED_EVENT_DETAILS_FIELD, LAMBDA_FUNCTION_SUCCEEDED_EVENT_DETAILS_FIELD, LAMBDA_FUNCTION_TIMED_OUT_EVENT_DETAILS_FIELD, STATE_ENTERED_EVENT_DETAILS_FIELD, STATE_EXITED_EVENT_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final String type;
    private final Long id;
    private final Long previousEventId;
    private final ActivityFailedEventDetails activityFailedEventDetails;
    private final ActivityScheduleFailedEventDetails activityScheduleFailedEventDetails;
    private final ActivityScheduledEventDetails activityScheduledEventDetails;
    private final ActivityStartedEventDetails activityStartedEventDetails;
    private final ActivitySucceededEventDetails activitySucceededEventDetails;
    private final ActivityTimedOutEventDetails activityTimedOutEventDetails;
    private final TaskFailedEventDetails taskFailedEventDetails;
    private final TaskScheduledEventDetails taskScheduledEventDetails;
    private final TaskStartFailedEventDetails taskStartFailedEventDetails;
    private final TaskStartedEventDetails taskStartedEventDetails;
    private final TaskSubmitFailedEventDetails taskSubmitFailedEventDetails;
    private final TaskSubmittedEventDetails taskSubmittedEventDetails;
    private final TaskSucceededEventDetails taskSucceededEventDetails;
    private final TaskTimedOutEventDetails taskTimedOutEventDetails;
    private final ExecutionFailedEventDetails executionFailedEventDetails;
    private final ExecutionStartedEventDetails executionStartedEventDetails;
    private final ExecutionSucceededEventDetails executionSucceededEventDetails;
    private final ExecutionAbortedEventDetails executionAbortedEventDetails;
    private final ExecutionTimedOutEventDetails executionTimedOutEventDetails;
    private final LambdaFunctionFailedEventDetails lambdaFunctionFailedEventDetails;
    private final LambdaFunctionScheduleFailedEventDetails lambdaFunctionScheduleFailedEventDetails;
    private final LambdaFunctionScheduledEventDetails lambdaFunctionScheduledEventDetails;
    private final LambdaFunctionStartFailedEventDetails lambdaFunctionStartFailedEventDetails;
    private final LambdaFunctionSucceededEventDetails lambdaFunctionSucceededEventDetails;
    private final LambdaFunctionTimedOutEventDetails lambdaFunctionTimedOutEventDetails;
    private final StateEnteredEventDetails stateEnteredEventDetails;
    private final StateExitedEventDetails stateExitedEventDetails;

    private HistoryEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.type = builder.type;
        this.id = builder.id;
        this.previousEventId = builder.previousEventId;
        this.activityFailedEventDetails = builder.activityFailedEventDetails;
        this.activityScheduleFailedEventDetails = builder.activityScheduleFailedEventDetails;
        this.activityScheduledEventDetails = builder.activityScheduledEventDetails;
        this.activityStartedEventDetails = builder.activityStartedEventDetails;
        this.activitySucceededEventDetails = builder.activitySucceededEventDetails;
        this.activityTimedOutEventDetails = builder.activityTimedOutEventDetails;
        this.taskFailedEventDetails = builder.taskFailedEventDetails;
        this.taskScheduledEventDetails = builder.taskScheduledEventDetails;
        this.taskStartFailedEventDetails = builder.taskStartFailedEventDetails;
        this.taskStartedEventDetails = builder.taskStartedEventDetails;
        this.taskSubmitFailedEventDetails = builder.taskSubmitFailedEventDetails;
        this.taskSubmittedEventDetails = builder.taskSubmittedEventDetails;
        this.taskSucceededEventDetails = builder.taskSucceededEventDetails;
        this.taskTimedOutEventDetails = builder.taskTimedOutEventDetails;
        this.executionFailedEventDetails = builder.executionFailedEventDetails;
        this.executionStartedEventDetails = builder.executionStartedEventDetails;
        this.executionSucceededEventDetails = builder.executionSucceededEventDetails;
        this.executionAbortedEventDetails = builder.executionAbortedEventDetails;
        this.executionTimedOutEventDetails = builder.executionTimedOutEventDetails;
        this.lambdaFunctionFailedEventDetails = builder.lambdaFunctionFailedEventDetails;
        this.lambdaFunctionScheduleFailedEventDetails = builder.lambdaFunctionScheduleFailedEventDetails;
        this.lambdaFunctionScheduledEventDetails = builder.lambdaFunctionScheduledEventDetails;
        this.lambdaFunctionStartFailedEventDetails = builder.lambdaFunctionStartFailedEventDetails;
        this.lambdaFunctionSucceededEventDetails = builder.lambdaFunctionSucceededEventDetails;
        this.lambdaFunctionTimedOutEventDetails = builder.lambdaFunctionTimedOutEventDetails;
        this.stateEnteredEventDetails = builder.stateEnteredEventDetails;
        this.stateExitedEventDetails = builder.stateExitedEventDetails;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public HistoryEventType type() {
        return HistoryEventType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Long id() {
        return this.id;
    }

    public Long previousEventId() {
        return this.previousEventId;
    }

    public ActivityFailedEventDetails activityFailedEventDetails() {
        return this.activityFailedEventDetails;
    }

    public ActivityScheduleFailedEventDetails activityScheduleFailedEventDetails() {
        return this.activityScheduleFailedEventDetails;
    }

    public ActivityScheduledEventDetails activityScheduledEventDetails() {
        return this.activityScheduledEventDetails;
    }

    public ActivityStartedEventDetails activityStartedEventDetails() {
        return this.activityStartedEventDetails;
    }

    public ActivitySucceededEventDetails activitySucceededEventDetails() {
        return this.activitySucceededEventDetails;
    }

    public ActivityTimedOutEventDetails activityTimedOutEventDetails() {
        return this.activityTimedOutEventDetails;
    }

    public TaskFailedEventDetails taskFailedEventDetails() {
        return this.taskFailedEventDetails;
    }

    public TaskScheduledEventDetails taskScheduledEventDetails() {
        return this.taskScheduledEventDetails;
    }

    public TaskStartFailedEventDetails taskStartFailedEventDetails() {
        return this.taskStartFailedEventDetails;
    }

    public TaskStartedEventDetails taskStartedEventDetails() {
        return this.taskStartedEventDetails;
    }

    public TaskSubmitFailedEventDetails taskSubmitFailedEventDetails() {
        return this.taskSubmitFailedEventDetails;
    }

    public TaskSubmittedEventDetails taskSubmittedEventDetails() {
        return this.taskSubmittedEventDetails;
    }

    public TaskSucceededEventDetails taskSucceededEventDetails() {
        return this.taskSucceededEventDetails;
    }

    public TaskTimedOutEventDetails taskTimedOutEventDetails() {
        return this.taskTimedOutEventDetails;
    }

    public ExecutionFailedEventDetails executionFailedEventDetails() {
        return this.executionFailedEventDetails;
    }

    public ExecutionStartedEventDetails executionStartedEventDetails() {
        return this.executionStartedEventDetails;
    }

    public ExecutionSucceededEventDetails executionSucceededEventDetails() {
        return this.executionSucceededEventDetails;
    }

    public ExecutionAbortedEventDetails executionAbortedEventDetails() {
        return this.executionAbortedEventDetails;
    }

    public ExecutionTimedOutEventDetails executionTimedOutEventDetails() {
        return this.executionTimedOutEventDetails;
    }

    public LambdaFunctionFailedEventDetails lambdaFunctionFailedEventDetails() {
        return this.lambdaFunctionFailedEventDetails;
    }

    public LambdaFunctionScheduleFailedEventDetails lambdaFunctionScheduleFailedEventDetails() {
        return this.lambdaFunctionScheduleFailedEventDetails;
    }

    public LambdaFunctionScheduledEventDetails lambdaFunctionScheduledEventDetails() {
        return this.lambdaFunctionScheduledEventDetails;
    }

    public LambdaFunctionStartFailedEventDetails lambdaFunctionStartFailedEventDetails() {
        return this.lambdaFunctionStartFailedEventDetails;
    }

    public LambdaFunctionSucceededEventDetails lambdaFunctionSucceededEventDetails() {
        return this.lambdaFunctionSucceededEventDetails;
    }

    public LambdaFunctionTimedOutEventDetails lambdaFunctionTimedOutEventDetails() {
        return this.lambdaFunctionTimedOutEventDetails;
    }

    public StateEnteredEventDetails stateEnteredEventDetails() {
        return this.stateEnteredEventDetails;
    }

    public StateExitedEventDetails stateExitedEventDetails() {
        return this.stateExitedEventDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityScheduleFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityScheduledEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityStartedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.activitySucceededEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityTimedOutEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskScheduledEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskSubmitFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskSubmittedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskSucceededEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTimedOutEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionSucceededEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionAbortedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimedOutEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionScheduleFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionScheduledEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionStartFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionSucceededEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionTimedOutEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateEnteredEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateExitedEventDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryEvent)) {
            return false;
        }
        HistoryEvent other = (HistoryEvent)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.previousEventId(), other.previousEventId()) && Objects.equals(this.activityFailedEventDetails(), other.activityFailedEventDetails()) && Objects.equals(this.activityScheduleFailedEventDetails(), other.activityScheduleFailedEventDetails()) && Objects.equals(this.activityScheduledEventDetails(), other.activityScheduledEventDetails()) && Objects.equals(this.activityStartedEventDetails(), other.activityStartedEventDetails()) && Objects.equals(this.activitySucceededEventDetails(), other.activitySucceededEventDetails()) && Objects.equals(this.activityTimedOutEventDetails(), other.activityTimedOutEventDetails()) && Objects.equals(this.taskFailedEventDetails(), other.taskFailedEventDetails()) && Objects.equals(this.taskScheduledEventDetails(), other.taskScheduledEventDetails()) && Objects.equals(this.taskStartFailedEventDetails(), other.taskStartFailedEventDetails()) && Objects.equals(this.taskStartedEventDetails(), other.taskStartedEventDetails()) && Objects.equals(this.taskSubmitFailedEventDetails(), other.taskSubmitFailedEventDetails()) && Objects.equals(this.taskSubmittedEventDetails(), other.taskSubmittedEventDetails()) && Objects.equals(this.taskSucceededEventDetails(), other.taskSucceededEventDetails()) && Objects.equals(this.taskTimedOutEventDetails(), other.taskTimedOutEventDetails()) && Objects.equals(this.executionFailedEventDetails(), other.executionFailedEventDetails()) && Objects.equals(this.executionStartedEventDetails(), other.executionStartedEventDetails()) && Objects.equals(this.executionSucceededEventDetails(), other.executionSucceededEventDetails()) && Objects.equals(this.executionAbortedEventDetails(), other.executionAbortedEventDetails()) && Objects.equals(this.executionTimedOutEventDetails(), other.executionTimedOutEventDetails()) && Objects.equals(this.lambdaFunctionFailedEventDetails(), other.lambdaFunctionFailedEventDetails()) && Objects.equals(this.lambdaFunctionScheduleFailedEventDetails(), other.lambdaFunctionScheduleFailedEventDetails()) && Objects.equals(this.lambdaFunctionScheduledEventDetails(), other.lambdaFunctionScheduledEventDetails()) && Objects.equals(this.lambdaFunctionStartFailedEventDetails(), other.lambdaFunctionStartFailedEventDetails()) && Objects.equals(this.lambdaFunctionSucceededEventDetails(), other.lambdaFunctionSucceededEventDetails()) && Objects.equals(this.lambdaFunctionTimedOutEventDetails(), other.lambdaFunctionTimedOutEventDetails()) && Objects.equals(this.stateEnteredEventDetails(), other.stateEnteredEventDetails()) && Objects.equals(this.stateExitedEventDetails(), other.stateExitedEventDetails());
    }

    public String toString() {
        return ToString.builder((String)"HistoryEvent").add("Timestamp", (Object)this.timestamp()).add("Type", (Object)this.typeAsString()).add("Id", (Object)this.id()).add("PreviousEventId", (Object)this.previousEventId()).add("ActivityFailedEventDetails", (Object)this.activityFailedEventDetails()).add("ActivityScheduleFailedEventDetails", (Object)this.activityScheduleFailedEventDetails()).add("ActivityScheduledEventDetails", (Object)this.activityScheduledEventDetails()).add("ActivityStartedEventDetails", (Object)this.activityStartedEventDetails()).add("ActivitySucceededEventDetails", (Object)this.activitySucceededEventDetails()).add("ActivityTimedOutEventDetails", (Object)this.activityTimedOutEventDetails()).add("TaskFailedEventDetails", (Object)this.taskFailedEventDetails()).add("TaskScheduledEventDetails", (Object)this.taskScheduledEventDetails()).add("TaskStartFailedEventDetails", (Object)this.taskStartFailedEventDetails()).add("TaskStartedEventDetails", (Object)this.taskStartedEventDetails()).add("TaskSubmitFailedEventDetails", (Object)this.taskSubmitFailedEventDetails()).add("TaskSubmittedEventDetails", (Object)this.taskSubmittedEventDetails()).add("TaskSucceededEventDetails", (Object)this.taskSucceededEventDetails()).add("TaskTimedOutEventDetails", (Object)this.taskTimedOutEventDetails()).add("ExecutionFailedEventDetails", (Object)this.executionFailedEventDetails()).add("ExecutionStartedEventDetails", (Object)this.executionStartedEventDetails()).add("ExecutionSucceededEventDetails", (Object)this.executionSucceededEventDetails()).add("ExecutionAbortedEventDetails", (Object)this.executionAbortedEventDetails()).add("ExecutionTimedOutEventDetails", (Object)this.executionTimedOutEventDetails()).add("LambdaFunctionFailedEventDetails", (Object)this.lambdaFunctionFailedEventDetails()).add("LambdaFunctionScheduleFailedEventDetails", (Object)this.lambdaFunctionScheduleFailedEventDetails()).add("LambdaFunctionScheduledEventDetails", (Object)this.lambdaFunctionScheduledEventDetails()).add("LambdaFunctionStartFailedEventDetails", (Object)this.lambdaFunctionStartFailedEventDetails()).add("LambdaFunctionSucceededEventDetails", (Object)this.lambdaFunctionSucceededEventDetails()).add("LambdaFunctionTimedOutEventDetails", (Object)this.lambdaFunctionTimedOutEventDetails()).add("StateEnteredEventDetails", (Object)this.stateEnteredEventDetails()).add("StateExitedEventDetails", (Object)this.stateExitedEventDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "previousEventId": {
                return Optional.ofNullable(clazz.cast(this.previousEventId()));
            }
            case "activityFailedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.activityFailedEventDetails()));
            }
            case "activityScheduleFailedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.activityScheduleFailedEventDetails()));
            }
            case "activityScheduledEventDetails": {
                return Optional.ofNullable(clazz.cast(this.activityScheduledEventDetails()));
            }
            case "activityStartedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.activityStartedEventDetails()));
            }
            case "activitySucceededEventDetails": {
                return Optional.ofNullable(clazz.cast(this.activitySucceededEventDetails()));
            }
            case "activityTimedOutEventDetails": {
                return Optional.ofNullable(clazz.cast(this.activityTimedOutEventDetails()));
            }
            case "taskFailedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.taskFailedEventDetails()));
            }
            case "taskScheduledEventDetails": {
                return Optional.ofNullable(clazz.cast(this.taskScheduledEventDetails()));
            }
            case "taskStartFailedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.taskStartFailedEventDetails()));
            }
            case "taskStartedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.taskStartedEventDetails()));
            }
            case "taskSubmitFailedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.taskSubmitFailedEventDetails()));
            }
            case "taskSubmittedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.taskSubmittedEventDetails()));
            }
            case "taskSucceededEventDetails": {
                return Optional.ofNullable(clazz.cast(this.taskSucceededEventDetails()));
            }
            case "taskTimedOutEventDetails": {
                return Optional.ofNullable(clazz.cast(this.taskTimedOutEventDetails()));
            }
            case "executionFailedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.executionFailedEventDetails()));
            }
            case "executionStartedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.executionStartedEventDetails()));
            }
            case "executionSucceededEventDetails": {
                return Optional.ofNullable(clazz.cast(this.executionSucceededEventDetails()));
            }
            case "executionAbortedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.executionAbortedEventDetails()));
            }
            case "executionTimedOutEventDetails": {
                return Optional.ofNullable(clazz.cast(this.executionTimedOutEventDetails()));
            }
            case "lambdaFunctionFailedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionFailedEventDetails()));
            }
            case "lambdaFunctionScheduleFailedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionScheduleFailedEventDetails()));
            }
            case "lambdaFunctionScheduledEventDetails": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionScheduledEventDetails()));
            }
            case "lambdaFunctionStartFailedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionStartFailedEventDetails()));
            }
            case "lambdaFunctionSucceededEventDetails": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionSucceededEventDetails()));
            }
            case "lambdaFunctionTimedOutEventDetails": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionTimedOutEventDetails()));
            }
            case "stateEnteredEventDetails": {
                return Optional.ofNullable(clazz.cast(this.stateEnteredEventDetails()));
            }
            case "stateExitedEventDetails": {
                return Optional.ofNullable(clazz.cast(this.stateExitedEventDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HistoryEvent, T> g) {
        return obj -> g.apply((HistoryEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private String type;
        private Long id;
        private Long previousEventId;
        private ActivityFailedEventDetails activityFailedEventDetails;
        private ActivityScheduleFailedEventDetails activityScheduleFailedEventDetails;
        private ActivityScheduledEventDetails activityScheduledEventDetails;
        private ActivityStartedEventDetails activityStartedEventDetails;
        private ActivitySucceededEventDetails activitySucceededEventDetails;
        private ActivityTimedOutEventDetails activityTimedOutEventDetails;
        private TaskFailedEventDetails taskFailedEventDetails;
        private TaskScheduledEventDetails taskScheduledEventDetails;
        private TaskStartFailedEventDetails taskStartFailedEventDetails;
        private TaskStartedEventDetails taskStartedEventDetails;
        private TaskSubmitFailedEventDetails taskSubmitFailedEventDetails;
        private TaskSubmittedEventDetails taskSubmittedEventDetails;
        private TaskSucceededEventDetails taskSucceededEventDetails;
        private TaskTimedOutEventDetails taskTimedOutEventDetails;
        private ExecutionFailedEventDetails executionFailedEventDetails;
        private ExecutionStartedEventDetails executionStartedEventDetails;
        private ExecutionSucceededEventDetails executionSucceededEventDetails;
        private ExecutionAbortedEventDetails executionAbortedEventDetails;
        private ExecutionTimedOutEventDetails executionTimedOutEventDetails;
        private LambdaFunctionFailedEventDetails lambdaFunctionFailedEventDetails;
        private LambdaFunctionScheduleFailedEventDetails lambdaFunctionScheduleFailedEventDetails;
        private LambdaFunctionScheduledEventDetails lambdaFunctionScheduledEventDetails;
        private LambdaFunctionStartFailedEventDetails lambdaFunctionStartFailedEventDetails;
        private LambdaFunctionSucceededEventDetails lambdaFunctionSucceededEventDetails;
        private LambdaFunctionTimedOutEventDetails lambdaFunctionTimedOutEventDetails;
        private StateEnteredEventDetails stateEnteredEventDetails;
        private StateExitedEventDetails stateExitedEventDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryEvent model) {
            this.timestamp(model.timestamp);
            this.type(model.type);
            this.id(model.id);
            this.previousEventId(model.previousEventId);
            this.activityFailedEventDetails(model.activityFailedEventDetails);
            this.activityScheduleFailedEventDetails(model.activityScheduleFailedEventDetails);
            this.activityScheduledEventDetails(model.activityScheduledEventDetails);
            this.activityStartedEventDetails(model.activityStartedEventDetails);
            this.activitySucceededEventDetails(model.activitySucceededEventDetails);
            this.activityTimedOutEventDetails(model.activityTimedOutEventDetails);
            this.taskFailedEventDetails(model.taskFailedEventDetails);
            this.taskScheduledEventDetails(model.taskScheduledEventDetails);
            this.taskStartFailedEventDetails(model.taskStartFailedEventDetails);
            this.taskStartedEventDetails(model.taskStartedEventDetails);
            this.taskSubmitFailedEventDetails(model.taskSubmitFailedEventDetails);
            this.taskSubmittedEventDetails(model.taskSubmittedEventDetails);
            this.taskSucceededEventDetails(model.taskSucceededEventDetails);
            this.taskTimedOutEventDetails(model.taskTimedOutEventDetails);
            this.executionFailedEventDetails(model.executionFailedEventDetails);
            this.executionStartedEventDetails(model.executionStartedEventDetails);
            this.executionSucceededEventDetails(model.executionSucceededEventDetails);
            this.executionAbortedEventDetails(model.executionAbortedEventDetails);
            this.executionTimedOutEventDetails(model.executionTimedOutEventDetails);
            this.lambdaFunctionFailedEventDetails(model.lambdaFunctionFailedEventDetails);
            this.lambdaFunctionScheduleFailedEventDetails(model.lambdaFunctionScheduleFailedEventDetails);
            this.lambdaFunctionScheduledEventDetails(model.lambdaFunctionScheduledEventDetails);
            this.lambdaFunctionStartFailedEventDetails(model.lambdaFunctionStartFailedEventDetails);
            this.lambdaFunctionSucceededEventDetails(model.lambdaFunctionSucceededEventDetails);
            this.lambdaFunctionTimedOutEventDetails(model.lambdaFunctionTimedOutEventDetails);
            this.stateEnteredEventDetails(model.stateEnteredEventDetails);
            this.stateExitedEventDetails(model.stateExitedEventDetails);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HistoryEventType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getId() {
            return this.id;
        }

        @Override
        public final Builder id(Long id) {
            this.id = id;
            return this;
        }

        public final void setId(Long id) {
            this.id = id;
        }

        public final Long getPreviousEventId() {
            return this.previousEventId;
        }

        @Override
        public final Builder previousEventId(Long previousEventId) {
            this.previousEventId = previousEventId;
            return this;
        }

        public final void setPreviousEventId(Long previousEventId) {
            this.previousEventId = previousEventId;
        }

        public final ActivityFailedEventDetails.Builder getActivityFailedEventDetails() {
            return this.activityFailedEventDetails != null ? this.activityFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activityFailedEventDetails(ActivityFailedEventDetails activityFailedEventDetails) {
            this.activityFailedEventDetails = activityFailedEventDetails;
            return this;
        }

        public final void setActivityFailedEventDetails(ActivityFailedEventDetails.BuilderImpl activityFailedEventDetails) {
            this.activityFailedEventDetails = activityFailedEventDetails != null ? activityFailedEventDetails.build() : null;
        }

        public final ActivityScheduleFailedEventDetails.Builder getActivityScheduleFailedEventDetails() {
            return this.activityScheduleFailedEventDetails != null ? this.activityScheduleFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activityScheduleFailedEventDetails(ActivityScheduleFailedEventDetails activityScheduleFailedEventDetails) {
            this.activityScheduleFailedEventDetails = activityScheduleFailedEventDetails;
            return this;
        }

        public final void setActivityScheduleFailedEventDetails(ActivityScheduleFailedEventDetails.BuilderImpl activityScheduleFailedEventDetails) {
            this.activityScheduleFailedEventDetails = activityScheduleFailedEventDetails != null ? activityScheduleFailedEventDetails.build() : null;
        }

        public final ActivityScheduledEventDetails.Builder getActivityScheduledEventDetails() {
            return this.activityScheduledEventDetails != null ? this.activityScheduledEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activityScheduledEventDetails(ActivityScheduledEventDetails activityScheduledEventDetails) {
            this.activityScheduledEventDetails = activityScheduledEventDetails;
            return this;
        }

        public final void setActivityScheduledEventDetails(ActivityScheduledEventDetails.BuilderImpl activityScheduledEventDetails) {
            this.activityScheduledEventDetails = activityScheduledEventDetails != null ? activityScheduledEventDetails.build() : null;
        }

        public final ActivityStartedEventDetails.Builder getActivityStartedEventDetails() {
            return this.activityStartedEventDetails != null ? this.activityStartedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activityStartedEventDetails(ActivityStartedEventDetails activityStartedEventDetails) {
            this.activityStartedEventDetails = activityStartedEventDetails;
            return this;
        }

        public final void setActivityStartedEventDetails(ActivityStartedEventDetails.BuilderImpl activityStartedEventDetails) {
            this.activityStartedEventDetails = activityStartedEventDetails != null ? activityStartedEventDetails.build() : null;
        }

        public final ActivitySucceededEventDetails.Builder getActivitySucceededEventDetails() {
            return this.activitySucceededEventDetails != null ? this.activitySucceededEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activitySucceededEventDetails(ActivitySucceededEventDetails activitySucceededEventDetails) {
            this.activitySucceededEventDetails = activitySucceededEventDetails;
            return this;
        }

        public final void setActivitySucceededEventDetails(ActivitySucceededEventDetails.BuilderImpl activitySucceededEventDetails) {
            this.activitySucceededEventDetails = activitySucceededEventDetails != null ? activitySucceededEventDetails.build() : null;
        }

        public final ActivityTimedOutEventDetails.Builder getActivityTimedOutEventDetails() {
            return this.activityTimedOutEventDetails != null ? this.activityTimedOutEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activityTimedOutEventDetails(ActivityTimedOutEventDetails activityTimedOutEventDetails) {
            this.activityTimedOutEventDetails = activityTimedOutEventDetails;
            return this;
        }

        public final void setActivityTimedOutEventDetails(ActivityTimedOutEventDetails.BuilderImpl activityTimedOutEventDetails) {
            this.activityTimedOutEventDetails = activityTimedOutEventDetails != null ? activityTimedOutEventDetails.build() : null;
        }

        public final TaskFailedEventDetails.Builder getTaskFailedEventDetails() {
            return this.taskFailedEventDetails != null ? this.taskFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskFailedEventDetails(TaskFailedEventDetails taskFailedEventDetails) {
            this.taskFailedEventDetails = taskFailedEventDetails;
            return this;
        }

        public final void setTaskFailedEventDetails(TaskFailedEventDetails.BuilderImpl taskFailedEventDetails) {
            this.taskFailedEventDetails = taskFailedEventDetails != null ? taskFailedEventDetails.build() : null;
        }

        public final TaskScheduledEventDetails.Builder getTaskScheduledEventDetails() {
            return this.taskScheduledEventDetails != null ? this.taskScheduledEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskScheduledEventDetails(TaskScheduledEventDetails taskScheduledEventDetails) {
            this.taskScheduledEventDetails = taskScheduledEventDetails;
            return this;
        }

        public final void setTaskScheduledEventDetails(TaskScheduledEventDetails.BuilderImpl taskScheduledEventDetails) {
            this.taskScheduledEventDetails = taskScheduledEventDetails != null ? taskScheduledEventDetails.build() : null;
        }

        public final TaskStartFailedEventDetails.Builder getTaskStartFailedEventDetails() {
            return this.taskStartFailedEventDetails != null ? this.taskStartFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskStartFailedEventDetails(TaskStartFailedEventDetails taskStartFailedEventDetails) {
            this.taskStartFailedEventDetails = taskStartFailedEventDetails;
            return this;
        }

        public final void setTaskStartFailedEventDetails(TaskStartFailedEventDetails.BuilderImpl taskStartFailedEventDetails) {
            this.taskStartFailedEventDetails = taskStartFailedEventDetails != null ? taskStartFailedEventDetails.build() : null;
        }

        public final TaskStartedEventDetails.Builder getTaskStartedEventDetails() {
            return this.taskStartedEventDetails != null ? this.taskStartedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskStartedEventDetails(TaskStartedEventDetails taskStartedEventDetails) {
            this.taskStartedEventDetails = taskStartedEventDetails;
            return this;
        }

        public final void setTaskStartedEventDetails(TaskStartedEventDetails.BuilderImpl taskStartedEventDetails) {
            this.taskStartedEventDetails = taskStartedEventDetails != null ? taskStartedEventDetails.build() : null;
        }

        public final TaskSubmitFailedEventDetails.Builder getTaskSubmitFailedEventDetails() {
            return this.taskSubmitFailedEventDetails != null ? this.taskSubmitFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskSubmitFailedEventDetails(TaskSubmitFailedEventDetails taskSubmitFailedEventDetails) {
            this.taskSubmitFailedEventDetails = taskSubmitFailedEventDetails;
            return this;
        }

        public final void setTaskSubmitFailedEventDetails(TaskSubmitFailedEventDetails.BuilderImpl taskSubmitFailedEventDetails) {
            this.taskSubmitFailedEventDetails = taskSubmitFailedEventDetails != null ? taskSubmitFailedEventDetails.build() : null;
        }

        public final TaskSubmittedEventDetails.Builder getTaskSubmittedEventDetails() {
            return this.taskSubmittedEventDetails != null ? this.taskSubmittedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskSubmittedEventDetails(TaskSubmittedEventDetails taskSubmittedEventDetails) {
            this.taskSubmittedEventDetails = taskSubmittedEventDetails;
            return this;
        }

        public final void setTaskSubmittedEventDetails(TaskSubmittedEventDetails.BuilderImpl taskSubmittedEventDetails) {
            this.taskSubmittedEventDetails = taskSubmittedEventDetails != null ? taskSubmittedEventDetails.build() : null;
        }

        public final TaskSucceededEventDetails.Builder getTaskSucceededEventDetails() {
            return this.taskSucceededEventDetails != null ? this.taskSucceededEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskSucceededEventDetails(TaskSucceededEventDetails taskSucceededEventDetails) {
            this.taskSucceededEventDetails = taskSucceededEventDetails;
            return this;
        }

        public final void setTaskSucceededEventDetails(TaskSucceededEventDetails.BuilderImpl taskSucceededEventDetails) {
            this.taskSucceededEventDetails = taskSucceededEventDetails != null ? taskSucceededEventDetails.build() : null;
        }

        public final TaskTimedOutEventDetails.Builder getTaskTimedOutEventDetails() {
            return this.taskTimedOutEventDetails != null ? this.taskTimedOutEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskTimedOutEventDetails(TaskTimedOutEventDetails taskTimedOutEventDetails) {
            this.taskTimedOutEventDetails = taskTimedOutEventDetails;
            return this;
        }

        public final void setTaskTimedOutEventDetails(TaskTimedOutEventDetails.BuilderImpl taskTimedOutEventDetails) {
            this.taskTimedOutEventDetails = taskTimedOutEventDetails != null ? taskTimedOutEventDetails.build() : null;
        }

        public final ExecutionFailedEventDetails.Builder getExecutionFailedEventDetails() {
            return this.executionFailedEventDetails != null ? this.executionFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionFailedEventDetails(ExecutionFailedEventDetails executionFailedEventDetails) {
            this.executionFailedEventDetails = executionFailedEventDetails;
            return this;
        }

        public final void setExecutionFailedEventDetails(ExecutionFailedEventDetails.BuilderImpl executionFailedEventDetails) {
            this.executionFailedEventDetails = executionFailedEventDetails != null ? executionFailedEventDetails.build() : null;
        }

        public final ExecutionStartedEventDetails.Builder getExecutionStartedEventDetails() {
            return this.executionStartedEventDetails != null ? this.executionStartedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionStartedEventDetails(ExecutionStartedEventDetails executionStartedEventDetails) {
            this.executionStartedEventDetails = executionStartedEventDetails;
            return this;
        }

        public final void setExecutionStartedEventDetails(ExecutionStartedEventDetails.BuilderImpl executionStartedEventDetails) {
            this.executionStartedEventDetails = executionStartedEventDetails != null ? executionStartedEventDetails.build() : null;
        }

        public final ExecutionSucceededEventDetails.Builder getExecutionSucceededEventDetails() {
            return this.executionSucceededEventDetails != null ? this.executionSucceededEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionSucceededEventDetails(ExecutionSucceededEventDetails executionSucceededEventDetails) {
            this.executionSucceededEventDetails = executionSucceededEventDetails;
            return this;
        }

        public final void setExecutionSucceededEventDetails(ExecutionSucceededEventDetails.BuilderImpl executionSucceededEventDetails) {
            this.executionSucceededEventDetails = executionSucceededEventDetails != null ? executionSucceededEventDetails.build() : null;
        }

        public final ExecutionAbortedEventDetails.Builder getExecutionAbortedEventDetails() {
            return this.executionAbortedEventDetails != null ? this.executionAbortedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionAbortedEventDetails(ExecutionAbortedEventDetails executionAbortedEventDetails) {
            this.executionAbortedEventDetails = executionAbortedEventDetails;
            return this;
        }

        public final void setExecutionAbortedEventDetails(ExecutionAbortedEventDetails.BuilderImpl executionAbortedEventDetails) {
            this.executionAbortedEventDetails = executionAbortedEventDetails != null ? executionAbortedEventDetails.build() : null;
        }

        public final ExecutionTimedOutEventDetails.Builder getExecutionTimedOutEventDetails() {
            return this.executionTimedOutEventDetails != null ? this.executionTimedOutEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionTimedOutEventDetails(ExecutionTimedOutEventDetails executionTimedOutEventDetails) {
            this.executionTimedOutEventDetails = executionTimedOutEventDetails;
            return this;
        }

        public final void setExecutionTimedOutEventDetails(ExecutionTimedOutEventDetails.BuilderImpl executionTimedOutEventDetails) {
            this.executionTimedOutEventDetails = executionTimedOutEventDetails != null ? executionTimedOutEventDetails.build() : null;
        }

        public final LambdaFunctionFailedEventDetails.Builder getLambdaFunctionFailedEventDetails() {
            return this.lambdaFunctionFailedEventDetails != null ? this.lambdaFunctionFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionFailedEventDetails(LambdaFunctionFailedEventDetails lambdaFunctionFailedEventDetails) {
            this.lambdaFunctionFailedEventDetails = lambdaFunctionFailedEventDetails;
            return this;
        }

        public final void setLambdaFunctionFailedEventDetails(LambdaFunctionFailedEventDetails.BuilderImpl lambdaFunctionFailedEventDetails) {
            this.lambdaFunctionFailedEventDetails = lambdaFunctionFailedEventDetails != null ? lambdaFunctionFailedEventDetails.build() : null;
        }

        public final LambdaFunctionScheduleFailedEventDetails.Builder getLambdaFunctionScheduleFailedEventDetails() {
            return this.lambdaFunctionScheduleFailedEventDetails != null ? this.lambdaFunctionScheduleFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionScheduleFailedEventDetails(LambdaFunctionScheduleFailedEventDetails lambdaFunctionScheduleFailedEventDetails) {
            this.lambdaFunctionScheduleFailedEventDetails = lambdaFunctionScheduleFailedEventDetails;
            return this;
        }

        public final void setLambdaFunctionScheduleFailedEventDetails(LambdaFunctionScheduleFailedEventDetails.BuilderImpl lambdaFunctionScheduleFailedEventDetails) {
            this.lambdaFunctionScheduleFailedEventDetails = lambdaFunctionScheduleFailedEventDetails != null ? lambdaFunctionScheduleFailedEventDetails.build() : null;
        }

        public final LambdaFunctionScheduledEventDetails.Builder getLambdaFunctionScheduledEventDetails() {
            return this.lambdaFunctionScheduledEventDetails != null ? this.lambdaFunctionScheduledEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionScheduledEventDetails(LambdaFunctionScheduledEventDetails lambdaFunctionScheduledEventDetails) {
            this.lambdaFunctionScheduledEventDetails = lambdaFunctionScheduledEventDetails;
            return this;
        }

        public final void setLambdaFunctionScheduledEventDetails(LambdaFunctionScheduledEventDetails.BuilderImpl lambdaFunctionScheduledEventDetails) {
            this.lambdaFunctionScheduledEventDetails = lambdaFunctionScheduledEventDetails != null ? lambdaFunctionScheduledEventDetails.build() : null;
        }

        public final LambdaFunctionStartFailedEventDetails.Builder getLambdaFunctionStartFailedEventDetails() {
            return this.lambdaFunctionStartFailedEventDetails != null ? this.lambdaFunctionStartFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionStartFailedEventDetails(LambdaFunctionStartFailedEventDetails lambdaFunctionStartFailedEventDetails) {
            this.lambdaFunctionStartFailedEventDetails = lambdaFunctionStartFailedEventDetails;
            return this;
        }

        public final void setLambdaFunctionStartFailedEventDetails(LambdaFunctionStartFailedEventDetails.BuilderImpl lambdaFunctionStartFailedEventDetails) {
            this.lambdaFunctionStartFailedEventDetails = lambdaFunctionStartFailedEventDetails != null ? lambdaFunctionStartFailedEventDetails.build() : null;
        }

        public final LambdaFunctionSucceededEventDetails.Builder getLambdaFunctionSucceededEventDetails() {
            return this.lambdaFunctionSucceededEventDetails != null ? this.lambdaFunctionSucceededEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionSucceededEventDetails(LambdaFunctionSucceededEventDetails lambdaFunctionSucceededEventDetails) {
            this.lambdaFunctionSucceededEventDetails = lambdaFunctionSucceededEventDetails;
            return this;
        }

        public final void setLambdaFunctionSucceededEventDetails(LambdaFunctionSucceededEventDetails.BuilderImpl lambdaFunctionSucceededEventDetails) {
            this.lambdaFunctionSucceededEventDetails = lambdaFunctionSucceededEventDetails != null ? lambdaFunctionSucceededEventDetails.build() : null;
        }

        public final LambdaFunctionTimedOutEventDetails.Builder getLambdaFunctionTimedOutEventDetails() {
            return this.lambdaFunctionTimedOutEventDetails != null ? this.lambdaFunctionTimedOutEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionTimedOutEventDetails(LambdaFunctionTimedOutEventDetails lambdaFunctionTimedOutEventDetails) {
            this.lambdaFunctionTimedOutEventDetails = lambdaFunctionTimedOutEventDetails;
            return this;
        }

        public final void setLambdaFunctionTimedOutEventDetails(LambdaFunctionTimedOutEventDetails.BuilderImpl lambdaFunctionTimedOutEventDetails) {
            this.lambdaFunctionTimedOutEventDetails = lambdaFunctionTimedOutEventDetails != null ? lambdaFunctionTimedOutEventDetails.build() : null;
        }

        public final StateEnteredEventDetails.Builder getStateEnteredEventDetails() {
            return this.stateEnteredEventDetails != null ? this.stateEnteredEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder stateEnteredEventDetails(StateEnteredEventDetails stateEnteredEventDetails) {
            this.stateEnteredEventDetails = stateEnteredEventDetails;
            return this;
        }

        public final void setStateEnteredEventDetails(StateEnteredEventDetails.BuilderImpl stateEnteredEventDetails) {
            this.stateEnteredEventDetails = stateEnteredEventDetails != null ? stateEnteredEventDetails.build() : null;
        }

        public final StateExitedEventDetails.Builder getStateExitedEventDetails() {
            return this.stateExitedEventDetails != null ? this.stateExitedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder stateExitedEventDetails(StateExitedEventDetails stateExitedEventDetails) {
            this.stateExitedEventDetails = stateExitedEventDetails;
            return this;
        }

        public final void setStateExitedEventDetails(StateExitedEventDetails.BuilderImpl stateExitedEventDetails) {
            this.stateExitedEventDetails = stateExitedEventDetails != null ? stateExitedEventDetails.build() : null;
        }

        public HistoryEvent build() {
            return new HistoryEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HistoryEvent> {
        public Builder timestamp(Instant var1);

        public Builder type(String var1);

        public Builder type(HistoryEventType var1);

        public Builder id(Long var1);

        public Builder previousEventId(Long var1);

        public Builder activityFailedEventDetails(ActivityFailedEventDetails var1);

        default public Builder activityFailedEventDetails(Consumer<ActivityFailedEventDetails.Builder> activityFailedEventDetails) {
            return this.activityFailedEventDetails((ActivityFailedEventDetails)((ActivityFailedEventDetails.Builder)ActivityFailedEventDetails.builder().applyMutation(activityFailedEventDetails)).build());
        }

        public Builder activityScheduleFailedEventDetails(ActivityScheduleFailedEventDetails var1);

        default public Builder activityScheduleFailedEventDetails(Consumer<ActivityScheduleFailedEventDetails.Builder> activityScheduleFailedEventDetails) {
            return this.activityScheduleFailedEventDetails((ActivityScheduleFailedEventDetails)((ActivityScheduleFailedEventDetails.Builder)ActivityScheduleFailedEventDetails.builder().applyMutation(activityScheduleFailedEventDetails)).build());
        }

        public Builder activityScheduledEventDetails(ActivityScheduledEventDetails var1);

        default public Builder activityScheduledEventDetails(Consumer<ActivityScheduledEventDetails.Builder> activityScheduledEventDetails) {
            return this.activityScheduledEventDetails((ActivityScheduledEventDetails)((ActivityScheduledEventDetails.Builder)ActivityScheduledEventDetails.builder().applyMutation(activityScheduledEventDetails)).build());
        }

        public Builder activityStartedEventDetails(ActivityStartedEventDetails var1);

        default public Builder activityStartedEventDetails(Consumer<ActivityStartedEventDetails.Builder> activityStartedEventDetails) {
            return this.activityStartedEventDetails((ActivityStartedEventDetails)((ActivityStartedEventDetails.Builder)ActivityStartedEventDetails.builder().applyMutation(activityStartedEventDetails)).build());
        }

        public Builder activitySucceededEventDetails(ActivitySucceededEventDetails var1);

        default public Builder activitySucceededEventDetails(Consumer<ActivitySucceededEventDetails.Builder> activitySucceededEventDetails) {
            return this.activitySucceededEventDetails((ActivitySucceededEventDetails)((ActivitySucceededEventDetails.Builder)ActivitySucceededEventDetails.builder().applyMutation(activitySucceededEventDetails)).build());
        }

        public Builder activityTimedOutEventDetails(ActivityTimedOutEventDetails var1);

        default public Builder activityTimedOutEventDetails(Consumer<ActivityTimedOutEventDetails.Builder> activityTimedOutEventDetails) {
            return this.activityTimedOutEventDetails((ActivityTimedOutEventDetails)((ActivityTimedOutEventDetails.Builder)ActivityTimedOutEventDetails.builder().applyMutation(activityTimedOutEventDetails)).build());
        }

        public Builder taskFailedEventDetails(TaskFailedEventDetails var1);

        default public Builder taskFailedEventDetails(Consumer<TaskFailedEventDetails.Builder> taskFailedEventDetails) {
            return this.taskFailedEventDetails((TaskFailedEventDetails)((TaskFailedEventDetails.Builder)TaskFailedEventDetails.builder().applyMutation(taskFailedEventDetails)).build());
        }

        public Builder taskScheduledEventDetails(TaskScheduledEventDetails var1);

        default public Builder taskScheduledEventDetails(Consumer<TaskScheduledEventDetails.Builder> taskScheduledEventDetails) {
            return this.taskScheduledEventDetails((TaskScheduledEventDetails)((TaskScheduledEventDetails.Builder)TaskScheduledEventDetails.builder().applyMutation(taskScheduledEventDetails)).build());
        }

        public Builder taskStartFailedEventDetails(TaskStartFailedEventDetails var1);

        default public Builder taskStartFailedEventDetails(Consumer<TaskStartFailedEventDetails.Builder> taskStartFailedEventDetails) {
            return this.taskStartFailedEventDetails((TaskStartFailedEventDetails)((TaskStartFailedEventDetails.Builder)TaskStartFailedEventDetails.builder().applyMutation(taskStartFailedEventDetails)).build());
        }

        public Builder taskStartedEventDetails(TaskStartedEventDetails var1);

        default public Builder taskStartedEventDetails(Consumer<TaskStartedEventDetails.Builder> taskStartedEventDetails) {
            return this.taskStartedEventDetails((TaskStartedEventDetails)((TaskStartedEventDetails.Builder)TaskStartedEventDetails.builder().applyMutation(taskStartedEventDetails)).build());
        }

        public Builder taskSubmitFailedEventDetails(TaskSubmitFailedEventDetails var1);

        default public Builder taskSubmitFailedEventDetails(Consumer<TaskSubmitFailedEventDetails.Builder> taskSubmitFailedEventDetails) {
            return this.taskSubmitFailedEventDetails((TaskSubmitFailedEventDetails)((TaskSubmitFailedEventDetails.Builder)TaskSubmitFailedEventDetails.builder().applyMutation(taskSubmitFailedEventDetails)).build());
        }

        public Builder taskSubmittedEventDetails(TaskSubmittedEventDetails var1);

        default public Builder taskSubmittedEventDetails(Consumer<TaskSubmittedEventDetails.Builder> taskSubmittedEventDetails) {
            return this.taskSubmittedEventDetails((TaskSubmittedEventDetails)((TaskSubmittedEventDetails.Builder)TaskSubmittedEventDetails.builder().applyMutation(taskSubmittedEventDetails)).build());
        }

        public Builder taskSucceededEventDetails(TaskSucceededEventDetails var1);

        default public Builder taskSucceededEventDetails(Consumer<TaskSucceededEventDetails.Builder> taskSucceededEventDetails) {
            return this.taskSucceededEventDetails((TaskSucceededEventDetails)((TaskSucceededEventDetails.Builder)TaskSucceededEventDetails.builder().applyMutation(taskSucceededEventDetails)).build());
        }

        public Builder taskTimedOutEventDetails(TaskTimedOutEventDetails var1);

        default public Builder taskTimedOutEventDetails(Consumer<TaskTimedOutEventDetails.Builder> taskTimedOutEventDetails) {
            return this.taskTimedOutEventDetails((TaskTimedOutEventDetails)((TaskTimedOutEventDetails.Builder)TaskTimedOutEventDetails.builder().applyMutation(taskTimedOutEventDetails)).build());
        }

        public Builder executionFailedEventDetails(ExecutionFailedEventDetails var1);

        default public Builder executionFailedEventDetails(Consumer<ExecutionFailedEventDetails.Builder> executionFailedEventDetails) {
            return this.executionFailedEventDetails((ExecutionFailedEventDetails)((ExecutionFailedEventDetails.Builder)ExecutionFailedEventDetails.builder().applyMutation(executionFailedEventDetails)).build());
        }

        public Builder executionStartedEventDetails(ExecutionStartedEventDetails var1);

        default public Builder executionStartedEventDetails(Consumer<ExecutionStartedEventDetails.Builder> executionStartedEventDetails) {
            return this.executionStartedEventDetails((ExecutionStartedEventDetails)((ExecutionStartedEventDetails.Builder)ExecutionStartedEventDetails.builder().applyMutation(executionStartedEventDetails)).build());
        }

        public Builder executionSucceededEventDetails(ExecutionSucceededEventDetails var1);

        default public Builder executionSucceededEventDetails(Consumer<ExecutionSucceededEventDetails.Builder> executionSucceededEventDetails) {
            return this.executionSucceededEventDetails((ExecutionSucceededEventDetails)((ExecutionSucceededEventDetails.Builder)ExecutionSucceededEventDetails.builder().applyMutation(executionSucceededEventDetails)).build());
        }

        public Builder executionAbortedEventDetails(ExecutionAbortedEventDetails var1);

        default public Builder executionAbortedEventDetails(Consumer<ExecutionAbortedEventDetails.Builder> executionAbortedEventDetails) {
            return this.executionAbortedEventDetails((ExecutionAbortedEventDetails)((ExecutionAbortedEventDetails.Builder)ExecutionAbortedEventDetails.builder().applyMutation(executionAbortedEventDetails)).build());
        }

        public Builder executionTimedOutEventDetails(ExecutionTimedOutEventDetails var1);

        default public Builder executionTimedOutEventDetails(Consumer<ExecutionTimedOutEventDetails.Builder> executionTimedOutEventDetails) {
            return this.executionTimedOutEventDetails((ExecutionTimedOutEventDetails)((ExecutionTimedOutEventDetails.Builder)ExecutionTimedOutEventDetails.builder().applyMutation(executionTimedOutEventDetails)).build());
        }

        public Builder lambdaFunctionFailedEventDetails(LambdaFunctionFailedEventDetails var1);

        default public Builder lambdaFunctionFailedEventDetails(Consumer<LambdaFunctionFailedEventDetails.Builder> lambdaFunctionFailedEventDetails) {
            return this.lambdaFunctionFailedEventDetails((LambdaFunctionFailedEventDetails)((LambdaFunctionFailedEventDetails.Builder)LambdaFunctionFailedEventDetails.builder().applyMutation(lambdaFunctionFailedEventDetails)).build());
        }

        public Builder lambdaFunctionScheduleFailedEventDetails(LambdaFunctionScheduleFailedEventDetails var1);

        default public Builder lambdaFunctionScheduleFailedEventDetails(Consumer<LambdaFunctionScheduleFailedEventDetails.Builder> lambdaFunctionScheduleFailedEventDetails) {
            return this.lambdaFunctionScheduleFailedEventDetails((LambdaFunctionScheduleFailedEventDetails)((LambdaFunctionScheduleFailedEventDetails.Builder)LambdaFunctionScheduleFailedEventDetails.builder().applyMutation(lambdaFunctionScheduleFailedEventDetails)).build());
        }

        public Builder lambdaFunctionScheduledEventDetails(LambdaFunctionScheduledEventDetails var1);

        default public Builder lambdaFunctionScheduledEventDetails(Consumer<LambdaFunctionScheduledEventDetails.Builder> lambdaFunctionScheduledEventDetails) {
            return this.lambdaFunctionScheduledEventDetails((LambdaFunctionScheduledEventDetails)((LambdaFunctionScheduledEventDetails.Builder)LambdaFunctionScheduledEventDetails.builder().applyMutation(lambdaFunctionScheduledEventDetails)).build());
        }

        public Builder lambdaFunctionStartFailedEventDetails(LambdaFunctionStartFailedEventDetails var1);

        default public Builder lambdaFunctionStartFailedEventDetails(Consumer<LambdaFunctionStartFailedEventDetails.Builder> lambdaFunctionStartFailedEventDetails) {
            return this.lambdaFunctionStartFailedEventDetails((LambdaFunctionStartFailedEventDetails)((LambdaFunctionStartFailedEventDetails.Builder)LambdaFunctionStartFailedEventDetails.builder().applyMutation(lambdaFunctionStartFailedEventDetails)).build());
        }

        public Builder lambdaFunctionSucceededEventDetails(LambdaFunctionSucceededEventDetails var1);

        default public Builder lambdaFunctionSucceededEventDetails(Consumer<LambdaFunctionSucceededEventDetails.Builder> lambdaFunctionSucceededEventDetails) {
            return this.lambdaFunctionSucceededEventDetails((LambdaFunctionSucceededEventDetails)((LambdaFunctionSucceededEventDetails.Builder)LambdaFunctionSucceededEventDetails.builder().applyMutation(lambdaFunctionSucceededEventDetails)).build());
        }

        public Builder lambdaFunctionTimedOutEventDetails(LambdaFunctionTimedOutEventDetails var1);

        default public Builder lambdaFunctionTimedOutEventDetails(Consumer<LambdaFunctionTimedOutEventDetails.Builder> lambdaFunctionTimedOutEventDetails) {
            return this.lambdaFunctionTimedOutEventDetails((LambdaFunctionTimedOutEventDetails)((LambdaFunctionTimedOutEventDetails.Builder)LambdaFunctionTimedOutEventDetails.builder().applyMutation(lambdaFunctionTimedOutEventDetails)).build());
        }

        public Builder stateEnteredEventDetails(StateEnteredEventDetails var1);

        default public Builder stateEnteredEventDetails(Consumer<StateEnteredEventDetails.Builder> stateEnteredEventDetails) {
            return this.stateEnteredEventDetails((StateEnteredEventDetails)((StateEnteredEventDetails.Builder)StateEnteredEventDetails.builder().applyMutation(stateEnteredEventDetails)).build());
        }

        public Builder stateExitedEventDetails(StateExitedEventDetails var1);

        default public Builder stateExitedEventDetails(Consumer<StateExitedEventDetails.Builder> stateExitedEventDetails) {
            return this.stateExitedEventDetails((StateExitedEventDetails)((StateExitedEventDetails.Builder)StateExitedEventDetails.builder().applyMutation(stateExitedEventDetails)).build());
        }
    }
}

