/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HistoryEventType {
    ACTIVITY_FAILED("ActivityFailed"),
    ACTIVITY_SCHEDULED("ActivityScheduled"),
    ACTIVITY_SCHEDULE_FAILED("ActivityScheduleFailed"),
    ACTIVITY_STARTED("ActivityStarted"),
    ACTIVITY_SUCCEEDED("ActivitySucceeded"),
    ACTIVITY_TIMED_OUT("ActivityTimedOut"),
    CHOICE_STATE_ENTERED("ChoiceStateEntered"),
    CHOICE_STATE_EXITED("ChoiceStateExited"),
    EXECUTION_ABORTED("ExecutionAborted"),
    EXECUTION_FAILED("ExecutionFailed"),
    EXECUTION_STARTED("ExecutionStarted"),
    EXECUTION_SUCCEEDED("ExecutionSucceeded"),
    EXECUTION_TIMED_OUT("ExecutionTimedOut"),
    FAIL_STATE_ENTERED("FailStateEntered"),
    LAMBDA_FUNCTION_FAILED("LambdaFunctionFailed"),
    LAMBDA_FUNCTION_SCHEDULED("LambdaFunctionScheduled"),
    LAMBDA_FUNCTION_SCHEDULE_FAILED("LambdaFunctionScheduleFailed"),
    LAMBDA_FUNCTION_STARTED("LambdaFunctionStarted"),
    LAMBDA_FUNCTION_START_FAILED("LambdaFunctionStartFailed"),
    LAMBDA_FUNCTION_SUCCEEDED("LambdaFunctionSucceeded"),
    LAMBDA_FUNCTION_TIMED_OUT("LambdaFunctionTimedOut"),
    MAP_ITERATION_ABORTED("MapIterationAborted"),
    MAP_ITERATION_FAILED("MapIterationFailed"),
    MAP_ITERATION_STARTED("MapIterationStarted"),
    MAP_ITERATION_SUCCEEDED("MapIterationSucceeded"),
    MAP_STATE_ABORTED("MapStateAborted"),
    MAP_STATE_ENTERED("MapStateEntered"),
    MAP_STATE_EXITED("MapStateExited"),
    MAP_STATE_FAILED("MapStateFailed"),
    MAP_STATE_STARTED("MapStateStarted"),
    MAP_STATE_SUCCEEDED("MapStateSucceeded"),
    PARALLEL_STATE_ABORTED("ParallelStateAborted"),
    PARALLEL_STATE_ENTERED("ParallelStateEntered"),
    PARALLEL_STATE_EXITED("ParallelStateExited"),
    PARALLEL_STATE_FAILED("ParallelStateFailed"),
    PARALLEL_STATE_STARTED("ParallelStateStarted"),
    PARALLEL_STATE_SUCCEEDED("ParallelStateSucceeded"),
    PASS_STATE_ENTERED("PassStateEntered"),
    PASS_STATE_EXITED("PassStateExited"),
    SUCCEED_STATE_ENTERED("SucceedStateEntered"),
    SUCCEED_STATE_EXITED("SucceedStateExited"),
    TASK_FAILED("TaskFailed"),
    TASK_SCHEDULED("TaskScheduled"),
    TASK_STARTED("TaskStarted"),
    TASK_START_FAILED("TaskStartFailed"),
    TASK_STATE_ABORTED("TaskStateAborted"),
    TASK_STATE_ENTERED("TaskStateEntered"),
    TASK_STATE_EXITED("TaskStateExited"),
    TASK_SUBMIT_FAILED("TaskSubmitFailed"),
    TASK_SUBMITTED("TaskSubmitted"),
    TASK_SUCCEEDED("TaskSucceeded"),
    TASK_TIMED_OUT("TaskTimedOut"),
    WAIT_STATE_ABORTED("WaitStateAborted"),
    WAIT_STATE_ENTERED("WaitStateEntered"),
    WAIT_STATE_EXITED("WaitStateExited"),
    MAP_RUN_ABORTED("MapRunAborted"),
    MAP_RUN_FAILED("MapRunFailed"),
    MAP_RUN_STARTED("MapRunStarted"),
    MAP_RUN_SUCCEEDED("MapRunSucceeded"),
    EXECUTION_REDRIVEN("ExecutionRedriven"),
    MAP_RUN_REDRIVEN("MapRunRedriven"),
    EVALUATION_FAILED("EvaluationFailed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HistoryEventType> VALUE_MAP;
    private final String value;

    private HistoryEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HistoryEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HistoryEventType> knownValues() {
        EnumSet<HistoryEventType> knownValues = EnumSet.allOf(HistoryEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HistoryEventType.class, HistoryEventType::toString);
    }
}

