/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestStateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestStateConfiguration> {
    private static final SdkField<Integer> RETRIER_RETRY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retrierRetryCount").getter(TestStateConfiguration.getter(TestStateConfiguration::retrierRetryCount)).setter(TestStateConfiguration.setter(Builder::retrierRetryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrierRetryCount").build()}).build();
    private static final SdkField<String> ERROR_CAUSED_BY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCausedByState").getter(TestStateConfiguration.getter(TestStateConfiguration::errorCausedByState)).setter(TestStateConfiguration.setter(Builder::errorCausedByState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCausedByState").build()}).build();
    private static final SdkField<Integer> MAP_ITERATION_FAILURE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("mapIterationFailureCount").getter(TestStateConfiguration.getter(TestStateConfiguration::mapIterationFailureCount)).setter(TestStateConfiguration.setter(Builder::mapIterationFailureCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapIterationFailureCount").build()}).build();
    private static final SdkField<String> MAP_ITEM_READER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mapItemReaderData").getter(TestStateConfiguration.getter(TestStateConfiguration::mapItemReaderData)).setter(TestStateConfiguration.setter(Builder::mapItemReaderData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapItemReaderData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIER_RETRY_COUNT_FIELD, ERROR_CAUSED_BY_STATE_FIELD, MAP_ITERATION_FAILURE_COUNT_FIELD, MAP_ITEM_READER_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestStateConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer retrierRetryCount;
    private final String errorCausedByState;
    private final Integer mapIterationFailureCount;
    private final String mapItemReaderData;

    private TestStateConfiguration(BuilderImpl builder) {
        this.retrierRetryCount = builder.retrierRetryCount;
        this.errorCausedByState = builder.errorCausedByState;
        this.mapIterationFailureCount = builder.mapIterationFailureCount;
        this.mapItemReaderData = builder.mapItemReaderData;
    }

    public final Integer retrierRetryCount() {
        return this.retrierRetryCount;
    }

    public final String errorCausedByState() {
        return this.errorCausedByState;
    }

    public final Integer mapIterationFailureCount() {
        return this.mapIterationFailureCount;
    }

    public final String mapItemReaderData() {
        return this.mapItemReaderData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.retrierRetryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCausedByState());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapIterationFailureCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapItemReaderData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestStateConfiguration)) {
            return false;
        }
        TestStateConfiguration other = (TestStateConfiguration)obj;
        return Objects.equals(this.retrierRetryCount(), other.retrierRetryCount()) && Objects.equals(this.errorCausedByState(), other.errorCausedByState()) && Objects.equals(this.mapIterationFailureCount(), other.mapIterationFailureCount()) && Objects.equals(this.mapItemReaderData(), other.mapItemReaderData());
    }

    public final String toString() {
        return ToString.builder((String)"TestStateConfiguration").add("RetrierRetryCount", (Object)this.retrierRetryCount()).add("ErrorCausedByState", (Object)(this.errorCausedByState() == null ? null : "*** Sensitive Data Redacted ***")).add("MapIterationFailureCount", (Object)this.mapIterationFailureCount()).add("MapItemReaderData", (Object)(this.mapItemReaderData() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "retrierRetryCount": {
                return Optional.ofNullable(clazz.cast(this.retrierRetryCount()));
            }
            case "errorCausedByState": {
                return Optional.ofNullable(clazz.cast(this.errorCausedByState()));
            }
            case "mapIterationFailureCount": {
                return Optional.ofNullable(clazz.cast(this.mapIterationFailureCount()));
            }
            case "mapItemReaderData": {
                return Optional.ofNullable(clazz.cast(this.mapItemReaderData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("retrierRetryCount", RETRIER_RETRY_COUNT_FIELD);
        map.put("errorCausedByState", ERROR_CAUSED_BY_STATE_FIELD);
        map.put("mapIterationFailureCount", MAP_ITERATION_FAILURE_COUNT_FIELD);
        map.put("mapItemReaderData", MAP_ITEM_READER_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestStateConfiguration, T> g) {
        return obj -> g.apply((TestStateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer retrierRetryCount;
        private String errorCausedByState;
        private Integer mapIterationFailureCount;
        private String mapItemReaderData;

        private BuilderImpl() {
        }

        private BuilderImpl(TestStateConfiguration model) {
            this.retrierRetryCount(model.retrierRetryCount);
            this.errorCausedByState(model.errorCausedByState);
            this.mapIterationFailureCount(model.mapIterationFailureCount);
            this.mapItemReaderData(model.mapItemReaderData);
        }

        public final Integer getRetrierRetryCount() {
            return this.retrierRetryCount;
        }

        public final void setRetrierRetryCount(Integer retrierRetryCount) {
            this.retrierRetryCount = retrierRetryCount;
        }

        @Override
        public final Builder retrierRetryCount(Integer retrierRetryCount) {
            this.retrierRetryCount = retrierRetryCount;
            return this;
        }

        public final String getErrorCausedByState() {
            return this.errorCausedByState;
        }

        public final void setErrorCausedByState(String errorCausedByState) {
            this.errorCausedByState = errorCausedByState;
        }

        @Override
        public final Builder errorCausedByState(String errorCausedByState) {
            this.errorCausedByState = errorCausedByState;
            return this;
        }

        public final Integer getMapIterationFailureCount() {
            return this.mapIterationFailureCount;
        }

        public final void setMapIterationFailureCount(Integer mapIterationFailureCount) {
            this.mapIterationFailureCount = mapIterationFailureCount;
        }

        @Override
        public final Builder mapIterationFailureCount(Integer mapIterationFailureCount) {
            this.mapIterationFailureCount = mapIterationFailureCount;
            return this;
        }

        public final String getMapItemReaderData() {
            return this.mapItemReaderData;
        }

        public final void setMapItemReaderData(String mapItemReaderData) {
            this.mapItemReaderData = mapItemReaderData;
        }

        @Override
        public final Builder mapItemReaderData(String mapItemReaderData) {
            this.mapItemReaderData = mapItemReaderData;
            return this;
        }

        public TestStateConfiguration build() {
            return new TestStateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestStateConfiguration> {
        public Builder retrierRetryCount(Integer var1);

        public Builder errorCausedByState(String var1);

        public Builder mapIterationFailureCount(Integer var1);

        public Builder mapItemReaderData(String var1);
    }
}

