/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineListItem;

public class ListStateMachinesIterable
implements SdkIterable<ListStateMachinesResponse> {
    private final SfnClient client;
    private final ListStateMachinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStateMachinesIterable(SfnClient client, ListStateMachinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStateMachinesResponseFetcher();
    }

    public Iterator<ListStateMachinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StateMachineListItem> stateMachines() {
        Function<ListStateMachinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.stateMachines() != null) {
                return response.stateMachines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListStateMachinesIterable resume(ListStateMachinesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStateMachinesIterable(this.client, (ListStateMachinesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListStateMachinesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListStateMachinesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListStateMachinesResponseFetcher
    implements SyncPageFetcher<ListStateMachinesResponse> {
        private ListStateMachinesResponseFetcher() {
        }

        public boolean hasNextPage(ListStateMachinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStateMachinesResponse nextPage(ListStateMachinesResponse previousPage) {
            if (previousPage == null) {
                return ListStateMachinesIterable.this.client.listStateMachines(ListStateMachinesIterable.this.firstRequest);
            }
            return ListStateMachinesIterable.this.client.listStateMachines((ListStateMachinesRequest)((Object)ListStateMachinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

