/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStateMachineRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, CreateStateMachineRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStateMachineRequest.getter(CreateStateMachineRequest::name)).setter(CreateStateMachineRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStateMachineRequest.getter(CreateStateMachineRequest::definition)).setter(CreateStateMachineRequest.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStateMachineRequest.getter(CreateStateMachineRequest::roleArn)).setter(CreateStateMachineRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DEFINITION_FIELD, ROLE_ARN_FIELD));
    private final String name;
    private final String definition;
    private final String roleArn;

    private CreateStateMachineRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
    }

    public String name() {
        return this.name;
    }

    public String definition() {
        return this.definition;
    }

    public String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStateMachineRequest)) {
            return false;
        }
        CreateStateMachineRequest other = (CreateStateMachineRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateStateMachineRequest").add("Name", (Object)this.name()).add("Definition", (Object)(this.definition() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStateMachineRequest, T> g) {
        return obj -> g.apply((CreateStateMachineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String name;
        private String definition;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStateMachineRequest model) {
            super(model);
            this.name(model.name);
            this.definition(model.definition);
            this.roleArn(model.roleArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDefinition() {
            return this.definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStateMachineRequest build() {
            return new CreateStateMachineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStateMachineRequest> {
        public Builder name(String var1);

        public Builder definition(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

