/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.RoutingConfigurationListCopier;
import software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStateMachineAliasResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, DescribeStateMachineAliasResponse> {
    private static final SdkField<String> STATE_MACHINE_ALIAS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineAliasArn").getter(DescribeStateMachineAliasResponse.getter(DescribeStateMachineAliasResponse::stateMachineAliasArn)).setter(DescribeStateMachineAliasResponse.setter(Builder::stateMachineAliasArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineAliasArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeStateMachineAliasResponse.getter(DescribeStateMachineAliasResponse::name)).setter(DescribeStateMachineAliasResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeStateMachineAliasResponse.getter(DescribeStateMachineAliasResponse::description)).setter(DescribeStateMachineAliasResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<RoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routingConfiguration").getter(DescribeStateMachineAliasResponse.getter(DescribeStateMachineAliasResponse::routingConfiguration)).setter(DescribeStateMachineAliasResponse.setter(Builder::routingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingConfigurationListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(DescribeStateMachineAliasResponse.getter(DescribeStateMachineAliasResponse::creationDate)).setter(DescribeStateMachineAliasResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDate").getter(DescribeStateMachineAliasResponse.getter(DescribeStateMachineAliasResponse::updateDate)).setter(DescribeStateMachineAliasResponse.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ALIAS_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIGURATION_FIELD, CREATION_DATE_FIELD, UPDATE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStateMachineAliasResponse.memberNameToFieldInitializer();
    private final String stateMachineAliasArn;
    private final String name;
    private final String description;
    private final List<RoutingConfigurationListItem> routingConfiguration;
    private final Instant creationDate;
    private final Instant updateDate;

    private DescribeStateMachineAliasResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineAliasArn = builder.stateMachineAliasArn;
        this.name = builder.name;
        this.description = builder.description;
        this.routingConfiguration = builder.routingConfiguration;
        this.creationDate = builder.creationDate;
        this.updateDate = builder.updateDate;
    }

    public final String stateMachineAliasArn() {
        return this.stateMachineAliasArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRoutingConfiguration() {
        return this.routingConfiguration != null && !(this.routingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<RoutingConfigurationListItem> routingConfiguration() {
        return this.routingConfiguration;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingConfiguration() ? this.routingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStateMachineAliasResponse)) {
            return false;
        }
        DescribeStateMachineAliasResponse other = (DescribeStateMachineAliasResponse)((Object)obj);
        return Objects.equals(this.stateMachineAliasArn(), other.stateMachineAliasArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasRoutingConfiguration() == other.hasRoutingConfiguration() && Objects.equals(this.routingConfiguration(), other.routingConfiguration()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.updateDate(), other.updateDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStateMachineAliasResponse").add("StateMachineAliasArn", (Object)this.stateMachineAliasArn()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("RoutingConfiguration", this.hasRoutingConfiguration() ? this.routingConfiguration() : null).add("CreationDate", (Object)this.creationDate()).add("UpdateDate", (Object)this.updateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineAliasArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineAliasArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "routingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.routingConfiguration()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "updateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stateMachineAliasArn", STATE_MACHINE_ALIAS_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("routingConfiguration", ROUTING_CONFIGURATION_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("updateDate", UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStateMachineAliasResponse, T> g) {
        return obj -> g.apply((DescribeStateMachineAliasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String stateMachineAliasArn;
        private String name;
        private String description;
        private List<RoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;
        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStateMachineAliasResponse model) {
            super(model);
            this.stateMachineAliasArn(model.stateMachineAliasArn);
            this.name(model.name);
            this.description(model.description);
            this.routingConfiguration(model.routingConfiguration);
            this.creationDate(model.creationDate);
            this.updateDate(model.updateDate);
        }

        public final String getStateMachineAliasArn() {
            return this.stateMachineAliasArn;
        }

        public final void setStateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
        }

        @Override
        public final Builder stateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<RoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<RoutingConfigurationListItem.Builder> result = RoutingConfigurationListCopier.copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(Collection<RoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = RoutingConfigurationListCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<RoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = RoutingConfigurationListCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(RoutingConfigurationListItem ... routingConfiguration) {
            this.routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<RoutingConfigurationListItem.Builder> ... routingConfiguration) {
            this.routingConfiguration(Stream.of(routingConfiguration).map(c -> (RoutingConfigurationListItem)((RoutingConfigurationListItem.Builder)RoutingConfigurationListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        @Override
        public DescribeStateMachineAliasResponse build() {
            return new DescribeStateMachineAliasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStateMachineAliasResponse> {
        public Builder stateMachineAliasArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder routingConfiguration(Collection<RoutingConfigurationListItem> var1);

        public Builder routingConfiguration(RoutingConfigurationListItem ... var1);

        public Builder routingConfiguration(Consumer<RoutingConfigurationListItem.Builder> ... var1);

        public Builder creationDate(Instant var1);

        public Builder updateDate(Instant var1);
    }
}

