/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.SfnServiceClientConfiguration;
import software.amazon.awssdk.services.sfn.internal.SfnServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.sfn.model.ActivityAlreadyExistsException;
import software.amazon.awssdk.services.sfn.model.ActivityDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.ActivityLimitExceededException;
import software.amazon.awssdk.services.sfn.model.ActivityWorkerLimitExceededException;
import software.amazon.awssdk.services.sfn.model.ConflictException;
import software.amazon.awssdk.services.sfn.model.CreateActivityRequest;
import software.amazon.awssdk.services.sfn.model.CreateActivityResponse;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DeleteActivityRequest;
import software.amazon.awssdk.services.sfn.model.DeleteActivityResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeActivityRequest;
import software.amazon.awssdk.services.sfn.model.DescribeActivityResponse;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest;
import software.amazon.awssdk.services.sfn.model.DescribeMapRunResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.ExecutionAlreadyExistsException;
import software.amazon.awssdk.services.sfn.model.ExecutionDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.ExecutionLimitExceededException;
import software.amazon.awssdk.services.sfn.model.ExecutionNotRedrivableException;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse;
import software.amazon.awssdk.services.sfn.model.InvalidArnException;
import software.amazon.awssdk.services.sfn.model.InvalidDefinitionException;
import software.amazon.awssdk.services.sfn.model.InvalidEncryptionConfigurationException;
import software.amazon.awssdk.services.sfn.model.InvalidExecutionInputException;
import software.amazon.awssdk.services.sfn.model.InvalidLoggingConfigurationException;
import software.amazon.awssdk.services.sfn.model.InvalidNameException;
import software.amazon.awssdk.services.sfn.model.InvalidOutputException;
import software.amazon.awssdk.services.sfn.model.InvalidTokenException;
import software.amazon.awssdk.services.sfn.model.InvalidTracingConfigurationException;
import software.amazon.awssdk.services.sfn.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.sfn.model.KmsInvalidStateException;
import software.amazon.awssdk.services.sfn.model.KmsThrottlingException;
import software.amazon.awssdk.services.sfn.model.ListActivitiesRequest;
import software.amazon.awssdk.services.sfn.model.ListActivitiesResponse;
import software.amazon.awssdk.services.sfn.model.ListExecutionsRequest;
import software.amazon.awssdk.services.sfn.model.ListExecutionsResponse;
import software.amazon.awssdk.services.sfn.model.ListMapRunsRequest;
import software.amazon.awssdk.services.sfn.model.ListMapRunsResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse;
import software.amazon.awssdk.services.sfn.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sfn.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sfn.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest;
import software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionResponse;
import software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest;
import software.amazon.awssdk.services.sfn.model.RedriveExecutionResponse;
import software.amazon.awssdk.services.sfn.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskFailureResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessResponse;
import software.amazon.awssdk.services.sfn.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.sfn.model.SfnException;
import software.amazon.awssdk.services.sfn.model.StartExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StartSyncExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartSyncExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineAlreadyExistsException;
import software.amazon.awssdk.services.sfn.model.StateMachineDeletingException;
import software.amazon.awssdk.services.sfn.model.StateMachineDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.StateMachineLimitExceededException;
import software.amazon.awssdk.services.sfn.model.StateMachineTypeNotSupportedException;
import software.amazon.awssdk.services.sfn.model.StopExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StopExecutionResponse;
import software.amazon.awssdk.services.sfn.model.TagResourceRequest;
import software.amazon.awssdk.services.sfn.model.TagResourceResponse;
import software.amazon.awssdk.services.sfn.model.TaskDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.TaskTimedOutException;
import software.amazon.awssdk.services.sfn.model.TestStateRequest;
import software.amazon.awssdk.services.sfn.model.TestStateResponse;
import software.amazon.awssdk.services.sfn.model.TooManyTagsException;
import software.amazon.awssdk.services.sfn.model.UntagResourceRequest;
import software.amazon.awssdk.services.sfn.model.UntagResourceResponse;
import software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest;
import software.amazon.awssdk.services.sfn.model.UpdateMapRunResponse;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionRequest;
import software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionResponse;
import software.amazon.awssdk.services.sfn.model.ValidationException;
import software.amazon.awssdk.services.sfn.transform.CreateActivityRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.CreateStateMachineAliasRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.CreateStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DeleteActivityRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DeleteStateMachineAliasRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DeleteStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DeleteStateMachineVersionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeActivityRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeMapRunRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeStateMachineAliasRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeStateMachineForExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.GetActivityTaskRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.GetExecutionHistoryRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListActivitiesRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListExecutionsRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListMapRunsRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListStateMachineAliasesRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListStateMachineVersionsRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListStateMachinesRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.PublishStateMachineVersionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.RedriveExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.SendTaskFailureRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.SendTaskHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.SendTaskSuccessRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.StartExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.StartSyncExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.StopExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.TestStateRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.UpdateMapRunRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.UpdateStateMachineAliasRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.UpdateStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ValidateStateMachineDefinitionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSfnClient
implements SfnClient {
    private static final Logger log = Logger.loggerFor(DefaultSfnClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSfnClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"SFN#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateActivityResponse createActivity(CreateActivityRequest createActivityRequest) throws ActivityLimitExceededException, ActivityAlreadyExistsException, InvalidNameException, TooManyTagsException, InvalidEncryptionConfigurationException, KmsAccessDeniedException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateActivityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createActivityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, createActivityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateActivity");
            CreateActivityResponse createActivityResponse = (CreateActivityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateActivity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createActivityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateActivityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createActivityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$createActivity$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStateMachineResponse createStateMachine(CreateStateMachineRequest createStateMachineRequest) throws InvalidArnException, InvalidDefinitionException, InvalidNameException, InvalidLoggingConfigurationException, InvalidTracingConfigurationException, StateMachineAlreadyExistsException, StateMachineDeletingException, StateMachineLimitExceededException, StateMachineTypeNotSupportedException, TooManyTagsException, ValidationException, ConflictException, InvalidEncryptionConfigurationException, KmsAccessDeniedException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStateMachineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createStateMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, createStateMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStateMachine");
            CreateStateMachineResponse createStateMachineResponse = (CreateStateMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStateMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createStateMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createStateMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$createStateMachine$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStateMachineAliasResponse createStateMachineAlias(CreateStateMachineAliasRequest createStateMachineAliasRequest) throws InvalidArnException, InvalidNameException, ValidationException, StateMachineDeletingException, ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStateMachineAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createStateMachineAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, createStateMachineAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStateMachineAlias");
            CreateStateMachineAliasResponse createStateMachineAliasResponse = (CreateStateMachineAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStateMachineAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createStateMachineAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateStateMachineAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createStateMachineAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$createStateMachineAlias$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteActivityResponse deleteActivity(DeleteActivityRequest deleteActivityRequest) throws InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteActivityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteActivityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, deleteActivityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteActivity");
            DeleteActivityResponse deleteActivityResponse = (DeleteActivityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteActivity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteActivityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteActivityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteActivityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$deleteActivity$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStateMachineResponse deleteStateMachine(DeleteStateMachineRequest deleteStateMachineRequest) throws InvalidArnException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStateMachineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStateMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, deleteStateMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStateMachine");
            DeleteStateMachineResponse deleteStateMachineResponse = (DeleteStateMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStateMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteStateMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteStateMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$deleteStateMachine$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStateMachineAliasResponse deleteStateMachineAlias(DeleteStateMachineAliasRequest deleteStateMachineAliasRequest) throws ValidationException, InvalidArnException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStateMachineAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStateMachineAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, deleteStateMachineAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStateMachineAlias");
            DeleteStateMachineAliasResponse deleteStateMachineAliasResponse = (DeleteStateMachineAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStateMachineAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteStateMachineAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteStateMachineAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteStateMachineAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$deleteStateMachineAlias$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStateMachineVersionResponse deleteStateMachineVersion(DeleteStateMachineVersionRequest deleteStateMachineVersionRequest) throws ValidationException, InvalidArnException, ConflictException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStateMachineVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStateMachineVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, deleteStateMachineVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStateMachineVersion");
            DeleteStateMachineVersionResponse deleteStateMachineVersionResponse = (DeleteStateMachineVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStateMachineVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteStateMachineVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteStateMachineVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteStateMachineVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$deleteStateMachineVersion$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeActivityResponse describeActivity(DescribeActivityRequest describeActivityRequest) throws ActivityDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeActivityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeActivityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, describeActivityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeActivity");
            DescribeActivityResponse describeActivityResponse = (DescribeActivityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeActivity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeActivityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeActivityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeActivityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$describeActivity$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExecutionResponse describeExecution(DescribeExecutionRequest describeExecutionRequest) throws ExecutionDoesNotExistException, InvalidArnException, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, describeExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExecution");
            DescribeExecutionResponse describeExecutionResponse = (DescribeExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$describeExecution$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMapRunResponse describeMapRun(DescribeMapRunRequest describeMapRunRequest) throws ResourceNotFoundException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMapRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMapRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, describeMapRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMapRun");
            DescribeMapRunResponse describeMapRunResponse = (DescribeMapRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMapRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMapRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMapRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMapRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$describeMapRun$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStateMachineResponse describeStateMachine(DescribeStateMachineRequest describeStateMachineRequest) throws InvalidArnException, StateMachineDoesNotExistException, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStateMachineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStateMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, describeStateMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStateMachine");
            DescribeStateMachineResponse describeStateMachineResponse = (DescribeStateMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStateMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeStateMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeStateMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$describeStateMachine$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStateMachineAliasResponse describeStateMachineAlias(DescribeStateMachineAliasRequest describeStateMachineAliasRequest) throws ValidationException, InvalidArnException, ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStateMachineAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStateMachineAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, describeStateMachineAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStateMachineAlias");
            DescribeStateMachineAliasResponse describeStateMachineAliasResponse = (DescribeStateMachineAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStateMachineAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeStateMachineAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeStateMachineAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeStateMachineAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$describeStateMachineAlias$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStateMachineForExecutionResponse describeStateMachineForExecution(DescribeStateMachineForExecutionRequest describeStateMachineForExecutionRequest) throws ExecutionDoesNotExistException, InvalidArnException, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStateMachineForExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStateMachineForExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, describeStateMachineForExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStateMachineForExecution");
            DescribeStateMachineForExecutionResponse describeStateMachineForExecutionResponse = (DescribeStateMachineForExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStateMachineForExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeStateMachineForExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeStateMachineForExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeStateMachineForExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$describeStateMachineForExecution$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetActivityTaskResponse getActivityTask(GetActivityTaskRequest getActivityTaskRequest) throws ActivityDoesNotExistException, ActivityWorkerLimitExceededException, InvalidArnException, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetActivityTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getActivityTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, getActivityTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetActivityTask");
            GetActivityTaskResponse getActivityTaskResponse = (GetActivityTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetActivityTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getActivityTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetActivityTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getActivityTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$getActivityTask$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExecutionHistoryResponse getExecutionHistory(GetExecutionHistoryRequest getExecutionHistoryRequest) throws ExecutionDoesNotExistException, InvalidArnException, InvalidTokenException, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExecutionHistoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExecutionHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, getExecutionHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExecutionHistory");
            GetExecutionHistoryResponse getExecutionHistoryResponse = (GetExecutionHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExecutionHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getExecutionHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetExecutionHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getExecutionHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$getExecutionHistory$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListActivitiesResponse listActivities(ListActivitiesRequest listActivitiesRequest) throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActivitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listActivitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, listActivitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActivities");
            ListActivitiesResponse listActivitiesResponse = (ListActivitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActivities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listActivitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListActivitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listActivitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$listActivities$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExecutionsResponse listExecutions(ListExecutionsRequest listExecutionsRequest) throws InvalidArnException, InvalidTokenException, StateMachineDoesNotExistException, StateMachineTypeNotSupportedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, listExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExecutions");
            ListExecutionsResponse listExecutionsResponse = (ListExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$listExecutions$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMapRunsResponse listMapRuns(ListMapRunsRequest listMapRunsRequest) throws ExecutionDoesNotExistException, InvalidArnException, InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMapRunsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMapRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, listMapRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMapRuns");
            ListMapRunsResponse listMapRunsResponse = (ListMapRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMapRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMapRunsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMapRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMapRunsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$listMapRuns$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStateMachineAliasesResponse listStateMachineAliases(ListStateMachineAliasesRequest listStateMachineAliasesRequest) throws InvalidArnException, InvalidTokenException, ResourceNotFoundException, StateMachineDoesNotExistException, StateMachineDeletingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStateMachineAliasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStateMachineAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, listStateMachineAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStateMachineAliases");
            ListStateMachineAliasesResponse listStateMachineAliasesResponse = (ListStateMachineAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStateMachineAliases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listStateMachineAliasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListStateMachineAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listStateMachineAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$listStateMachineAliases$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStateMachineVersionsResponse listStateMachineVersions(ListStateMachineVersionsRequest listStateMachineVersionsRequest) throws ValidationException, InvalidArnException, InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStateMachineVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStateMachineVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, listStateMachineVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStateMachineVersions");
            ListStateMachineVersionsResponse listStateMachineVersionsResponse = (ListStateMachineVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStateMachineVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listStateMachineVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListStateMachineVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listStateMachineVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$listStateMachineVersions$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStateMachinesResponse listStateMachines(ListStateMachinesRequest listStateMachinesRequest) throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStateMachinesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStateMachinesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, listStateMachinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStateMachines");
            ListStateMachinesResponse listStateMachinesResponse = (ListStateMachinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStateMachines").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listStateMachinesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListStateMachinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listStateMachinesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$listStateMachines$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidArnException, ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$listTagsForResource$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublishStateMachineVersionResponse publishStateMachineVersion(PublishStateMachineVersionRequest publishStateMachineVersionRequest) throws ValidationException, StateMachineDeletingException, StateMachineDoesNotExistException, ServiceQuotaExceededException, ConflictException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PublishStateMachineVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)publishStateMachineVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, publishStateMachineVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PublishStateMachineVersion");
            PublishStateMachineVersionResponse publishStateMachineVersionResponse = (PublishStateMachineVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PublishStateMachineVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)publishStateMachineVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PublishStateMachineVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return publishStateMachineVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$publishStateMachineVersion$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RedriveExecutionResponse redriveExecution(RedriveExecutionRequest redriveExecutionRequest) throws ExecutionDoesNotExistException, ExecutionNotRedrivableException, ExecutionLimitExceededException, InvalidArnException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RedriveExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)redriveExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, redriveExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RedriveExecution");
            RedriveExecutionResponse redriveExecutionResponse = (RedriveExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RedriveExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)redriveExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RedriveExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return redriveExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$redriveExecution$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendTaskFailureResponse sendTaskFailure(SendTaskFailureRequest sendTaskFailureRequest) throws TaskDoesNotExistException, InvalidTokenException, TaskTimedOutException, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTaskFailureResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendTaskFailureRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, sendTaskFailureRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendTaskFailure");
            SendTaskFailureResponse sendTaskFailureResponse = (SendTaskFailureResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTaskFailure").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendTaskFailureRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendTaskFailureRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendTaskFailureResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$sendTaskFailure$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendTaskHeartbeatResponse sendTaskHeartbeat(SendTaskHeartbeatRequest sendTaskHeartbeatRequest) throws TaskDoesNotExistException, InvalidTokenException, TaskTimedOutException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTaskHeartbeatResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendTaskHeartbeatRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, sendTaskHeartbeatRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendTaskHeartbeat");
            SendTaskHeartbeatResponse sendTaskHeartbeatResponse = (SendTaskHeartbeatResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTaskHeartbeat").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendTaskHeartbeatRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendTaskHeartbeatRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendTaskHeartbeatResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$sendTaskHeartbeat$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendTaskSuccessResponse sendTaskSuccess(SendTaskSuccessRequest sendTaskSuccessRequest) throws TaskDoesNotExistException, InvalidOutputException, InvalidTokenException, TaskTimedOutException, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTaskSuccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendTaskSuccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, sendTaskSuccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendTaskSuccess");
            SendTaskSuccessResponse sendTaskSuccessResponse = (SendTaskSuccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTaskSuccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendTaskSuccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendTaskSuccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendTaskSuccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$sendTaskSuccess$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartExecutionResponse startExecution(StartExecutionRequest startExecutionRequest) throws ExecutionLimitExceededException, ExecutionAlreadyExistsException, InvalidArnException, InvalidExecutionInputException, InvalidNameException, StateMachineDoesNotExistException, StateMachineDeletingException, ValidationException, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, startExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartExecution");
            StartExecutionResponse startExecutionResponse = (StartExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$startExecution$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSyncExecutionResponse startSyncExecution(StartSyncExecutionRequest startSyncExecutionRequest) throws InvalidArnException, InvalidExecutionInputException, InvalidNameException, StateMachineDoesNotExistException, StateMachineDeletingException, StateMachineTypeNotSupportedException, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSyncExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSyncExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, startSyncExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSyncExecution");
            String hostPrefix = "sync-";
            String resolvedHostExpression = "sync-";
            StartSyncExecutionResponse startSyncExecutionResponse = (StartSyncExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSyncExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSyncExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSyncExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSyncExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$startSyncExecution$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopExecutionResponse stopExecution(StopExecutionRequest stopExecutionRequest) throws ExecutionDoesNotExistException, InvalidArnException, ValidationException, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, stopExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopExecution");
            StopExecutionResponse stopExecutionResponse = (StopExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$stopExecution$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidArnException, ResourceNotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$tagResource$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestStateResponse testState(TestStateRequest testStateRequest) throws InvalidArnException, InvalidDefinitionException, InvalidExecutionInputException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)testStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, testStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestState");
            String hostPrefix = "sync-";
            String resolvedHostExpression = "sync-";
            TestStateResponse testStateResponse = (TestStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)testStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TestStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$testState$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidArnException, ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$untagResource$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMapRunResponse updateMapRun(UpdateMapRunRequest updateMapRunRequest) throws ResourceNotFoundException, InvalidArnException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMapRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMapRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, updateMapRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMapRun");
            UpdateMapRunResponse updateMapRunResponse = (UpdateMapRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMapRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateMapRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMapRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMapRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$updateMapRun$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStateMachineResponse updateStateMachine(UpdateStateMachineRequest updateStateMachineRequest) throws InvalidArnException, InvalidDefinitionException, InvalidLoggingConfigurationException, InvalidTracingConfigurationException, MissingRequiredParameterException, StateMachineDeletingException, StateMachineDoesNotExistException, ServiceQuotaExceededException, ConflictException, ValidationException, InvalidEncryptionConfigurationException, KmsAccessDeniedException, KmsThrottlingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStateMachineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateStateMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, updateStateMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStateMachine");
            UpdateStateMachineResponse updateStateMachineResponse = (UpdateStateMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStateMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateStateMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateStateMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$updateStateMachine$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStateMachineAliasResponse updateStateMachineAlias(UpdateStateMachineAliasRequest updateStateMachineAliasRequest) throws ValidationException, InvalidArnException, ResourceNotFoundException, ConflictException, StateMachineDeletingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStateMachineAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateStateMachineAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, updateStateMachineAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStateMachineAlias");
            UpdateStateMachineAliasResponse updateStateMachineAliasResponse = (UpdateStateMachineAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStateMachineAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateStateMachineAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateStateMachineAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateStateMachineAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$updateStateMachineAlias$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidateStateMachineDefinitionResponse validateStateMachineDefinition(ValidateStateMachineDefinitionRequest validateStateMachineDefinitionRequest) throws ValidationException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ValidateStateMachineDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActivityDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                }
                case "StateMachineTypeNotSupported": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                }
                case "KmsThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InvalidDefinition": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                }
                case "InvalidName": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                }
                case "InvalidLoggingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "StateMachineAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                }
                case "ExecutionLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                }
                case "InvalidArn": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "StateMachineDeleting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                }
                case "ActivityWorkerLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                }
                case "TaskTimedOut": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                }
                case "ExecutionAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                }
                case "MissingRequiredParameter": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ExecutionDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "ExecutionNotRedrivable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                }
                case "StateMachineLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                }
                case "InvalidToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "TooManyTags": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEncryptionConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                }
                case "InvalidOutput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                }
                case "InvalidTracingConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActivityLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                }
                case "InvalidExecutionInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                }
                case "TaskDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KmsAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "StateMachineDoesNotExist": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                }
                case "ActivityAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)validateStateMachineDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnClient.resolveMetricPublishers(clientConfiguration, validateStateMachineDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ValidateStateMachineDefinition");
            ValidateStateMachineDefinitionResponse validateStateMachineDefinitionResponse = (ValidateStateMachineDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidateStateMachineDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)validateStateMachineDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ValidateStateMachineDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return validateStateMachineDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSfnClient.lambda$validateStateMachineDefinition$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "states";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SfnServiceClientConfigurationBuilder serviceConfigBuilder = new SfnServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SfnException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    @Override
    public final SfnServiceClientConfiguration serviceClientConfiguration() {
        return new SfnServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$validateStateMachineDefinition$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateStateMachineAlias$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateStateMachine$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMapRun$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testState$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopExecution$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSyncExecution$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startExecution$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendTaskSuccess$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendTaskHeartbeat$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendTaskFailure$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$redriveExecution$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$publishStateMachineVersion$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStateMachines$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStateMachineVersions$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStateMachineAliases$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMapRuns$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExecutions$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActivities$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExecutionHistory$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getActivityTask$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStateMachineForExecution$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStateMachineAlias$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStateMachine$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMapRun$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExecution$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeActivity$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStateMachineVersion$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStateMachineAlias$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStateMachine$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteActivity$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStateMachineAlias$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStateMachine$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createActivity$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

