/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a specific Map Run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MapRunListItem implements SdkPojo, Serializable, ToCopyableBuilder<MapRunListItem.Builder, MapRunListItem> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(MapRunListItem::executionArn)).setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<String> MAP_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mapRunArn").getter(getter(MapRunListItem::mapRunArn)).setter(setter(Builder::mapRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRunArn").build()).build();

    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineArn").getter(getter(MapRunListItem::stateMachineArn))
            .setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate").getter(getter(MapRunListItem::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()).build();

    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopDate").getter(getter(MapRunListItem::stopDate)).setter(setter(Builder::stopDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD,
            MAP_RUN_ARN_FIELD, STATE_MACHINE_ARN_FIELD, START_DATE_FIELD, STOP_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String executionArn;

    private final String mapRunArn;

    private final String stateMachineArn;

    private final Instant startDate;

    private final Instant stopDate;

    private MapRunListItem(BuilderImpl builder) {
        this.executionArn = builder.executionArn;
        this.mapRunArn = builder.mapRunArn;
        this.stateMachineArn = builder.stateMachineArn;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
    }

    /**
     * <p>
     * The <code>executionArn</code> of the execution from which the Map Run was started.
     * </p>
     * 
     * @return The <code>executionArn</code> of the execution from which the Map Run was started.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Map Run.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Map Run.
     */
    public final String mapRunArn() {
        return mapRunArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the executed state machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the executed state machine.
     */
    public final String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * The date on which the Map Run started.
     * </p>
     * 
     * @return The date on which the Map Run started.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date on which the Map Run stopped.
     * </p>
     * 
     * @return The date on which the Map Run stopped.
     */
    public final Instant stopDate() {
        return stopDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(mapRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(stopDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapRunListItem)) {
            return false;
        }
        MapRunListItem other = (MapRunListItem) obj;
        return Objects.equals(executionArn(), other.executionArn()) && Objects.equals(mapRunArn(), other.mapRunArn())
                && Objects.equals(stateMachineArn(), other.stateMachineArn()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(stopDate(), other.stopDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MapRunListItem").add("ExecutionArn", executionArn()).add("MapRunArn", mapRunArn())
                .add("StateMachineArn", stateMachineArn()).add("StartDate", startDate()).add("StopDate", stopDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "mapRunArn":
            return Optional.ofNullable(clazz.cast(mapRunArn()));
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "stopDate":
            return Optional.ofNullable(clazz.cast(stopDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionArn", EXECUTION_ARN_FIELD);
        map.put("mapRunArn", MAP_RUN_ARN_FIELD);
        map.put("stateMachineArn", STATE_MACHINE_ARN_FIELD);
        map.put("startDate", START_DATE_FIELD);
        map.put("stopDate", STOP_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MapRunListItem, T> g) {
        return obj -> g.apply((MapRunListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MapRunListItem> {
        /**
         * <p>
         * The <code>executionArn</code> of the execution from which the Map Run was started.
         * </p>
         * 
         * @param executionArn
         *        The <code>executionArn</code> of the execution from which the Map Run was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Map Run.
         * </p>
         * 
         * @param mapRunArn
         *        The Amazon Resource Name (ARN) of the Map Run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapRunArn(String mapRunArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the executed state machine.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) of the executed state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * The date on which the Map Run started.
         * </p>
         * 
         * @param startDate
         *        The date on which the Map Run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The date on which the Map Run stopped.
         * </p>
         * 
         * @param stopDate
         *        The date on which the Map Run stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopDate(Instant stopDate);
    }

    static final class BuilderImpl implements Builder {
        private String executionArn;

        private String mapRunArn;

        private String stateMachineArn;

        private Instant startDate;

        private Instant stopDate;

        private BuilderImpl() {
        }

        private BuilderImpl(MapRunListItem model) {
            executionArn(model.executionArn);
            mapRunArn(model.mapRunArn);
            stateMachineArn(model.stateMachineArn);
            startDate(model.startDate);
            stopDate(model.stopDate);
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getMapRunArn() {
            return mapRunArn;
        }

        public final void setMapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
        }

        @Override
        public final Builder mapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
            return this;
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getStopDate() {
            return stopDate;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        @Override
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        @Override
        public MapRunListItem build() {
            return new MapRunListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
