/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sfn.SfnAsyncClient;
import software.amazon.awssdk.services.sfn.model.ActivityListItem;
import software.amazon.awssdk.services.sfn.model.ListActivitiesRequest;
import software.amazon.awssdk.services.sfn.model.ListActivitiesResponse;

public class ListActivitiesPublisher
implements SdkPublisher<ListActivitiesResponse> {
    private final SfnAsyncClient client;
    private final ListActivitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListActivitiesPublisher(SfnAsyncClient client, ListActivitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListActivitiesPublisher(SfnAsyncClient client, ListActivitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListActivitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListActivitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActivityListItem> activities() {
        Function<ListActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.activities() != null) {
                return response.activities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListActivitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListActivitiesPublisher resume(ListActivitiesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListActivitiesPublisher(this.client, (ListActivitiesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListActivitiesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListActivitiesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListActivitiesResponseFetcher
    implements AsyncPageFetcher<ListActivitiesResponse> {
        private ListActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListActivitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListActivitiesResponse> nextPage(ListActivitiesResponse previousPage) {
            if (previousPage == null) {
                return ListActivitiesPublisher.this.client.listActivities(ListActivitiesPublisher.this.firstRequest);
            }
            return ListActivitiesPublisher.this.client.listActivities((ListActivitiesRequest)((Object)ListActivitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

