/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskScheduledEventDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskScheduledEventDetails> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskScheduledEventDetails.getter(TaskScheduledEventDetails::resourceType)).setter(TaskScheduledEventDetails.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskScheduledEventDetails.getter(TaskScheduledEventDetails::resource)).setter(TaskScheduledEventDetails.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskScheduledEventDetails.getter(TaskScheduledEventDetails::region)).setter(TaskScheduledEventDetails.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskScheduledEventDetails.getter(TaskScheduledEventDetails::parameters)).setter(TaskScheduledEventDetails.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final SdkField<Long> TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(TaskScheduledEventDetails.getter(TaskScheduledEventDetails::timeoutInSeconds)).setter(TaskScheduledEventDetails.setter(Builder::timeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_FIELD, REGION_FIELD, PARAMETERS_FIELD, TIMEOUT_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String resource;
    private final String region;
    private final String parameters;
    private final Long timeoutInSeconds;

    private TaskScheduledEventDetails(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resource = builder.resource;
        this.region = builder.region;
        this.parameters = builder.parameters;
        this.timeoutInSeconds = builder.timeoutInSeconds;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resource() {
        return this.resource;
    }

    public String region() {
        return this.region;
    }

    public String parameters() {
        return this.parameters;
    }

    public Long timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskScheduledEventDetails)) {
            return false;
        }
        TaskScheduledEventDetails other = (TaskScheduledEventDetails)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"TaskScheduledEventDetails").add("ResourceType", (Object)this.resourceType()).add("Resource", (Object)this.resource()).add("Region", (Object)this.region()).add("Parameters", (Object)this.parameters()).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "timeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskScheduledEventDetails, T> g) {
        return obj -> g.apply((TaskScheduledEventDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resource;
        private String region;
        private String parameters;
        private Long timeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskScheduledEventDetails model) {
            this.resourceType(model.resourceType);
            this.resource(model.resource);
            this.region(model.region);
            this.parameters(model.parameters);
            this.timeoutInSeconds(model.timeoutInSeconds);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public final Long getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public TaskScheduledEventDetails build() {
            return new TaskScheduledEventDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskScheduledEventDetails> {
        public Builder resourceType(String var1);

        public Builder resource(String var1);

        public Builder region(String var1);

        public Builder parameters(String var1);

        public Builder timeoutInSeconds(Long var1);
    }
}

