/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.ExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionListItem> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecutionListItem.getter(ExecutionListItem::executionArn)).setter(ExecutionListItem.setter(Builder::executionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()}).build();
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecutionListItem.getter(ExecutionListItem::stateMachineArn)).setter(ExecutionListItem.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecutionListItem.getter(ExecutionListItem::name)).setter(ExecutionListItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecutionListItem.getter(ExecutionListItem::statusAsString)).setter(ExecutionListItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ExecutionListItem.getter(ExecutionListItem::startDate)).setter(ExecutionListItem.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()}).build();
    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ExecutionListItem.getter(ExecutionListItem::stopDate)).setter(ExecutionListItem.setter(Builder::stopDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD, STATE_MACHINE_ARN_FIELD, NAME_FIELD, STATUS_FIELD, START_DATE_FIELD, STOP_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String executionArn;
    private final String stateMachineArn;
    private final String name;
    private final String status;
    private final Instant startDate;
    private final Instant stopDate;

    private ExecutionListItem(BuilderImpl builder) {
        this.executionArn = builder.executionArn;
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.status = builder.status;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
    }

    public String executionArn() {
        return this.executionArn;
    }

    public String stateMachineArn() {
        return this.stateMachineArn;
    }

    public String name() {
        return this.name;
    }

    public ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant startDate() {
        return this.startDate;
    }

    public Instant stopDate() {
        return this.stopDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionListItem)) {
            return false;
        }
        ExecutionListItem other = (ExecutionListItem)obj;
        return Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.stopDate(), other.stopDate());
    }

    public String toString() {
        return ToString.builder((String)"ExecutionListItem").add("ExecutionArn", (Object)this.executionArn()).add("StateMachineArn", (Object)this.stateMachineArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("StartDate", (Object)this.startDate()).add("StopDate", (Object)this.stopDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "stopDate": {
                return Optional.ofNullable(clazz.cast(this.stopDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionListItem, T> g) {
        return obj -> g.apply((ExecutionListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionArn;
        private String stateMachineArn;
        private String name;
        private String status;
        private Instant startDate;
        private Instant stopDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionListItem model) {
            this.executionArn(model.executionArn);
            this.stateMachineArn(model.stateMachineArn);
            this.name(model.name);
            this.status(model.status);
            this.startDate(model.startDate);
            this.stopDate(model.stopDate);
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getStopDate() {
            return this.stopDate;
        }

        @Override
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        public ExecutionListItem build() {
            return new ExecutionListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionListItem> {
        public Builder executionArn(String var1);

        public Builder stateMachineArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder startDate(Instant var1);

        public Builder stopDate(Instant var1);
    }
}

