/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InspectionDataRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InspectionDataRequest> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(InspectionDataRequest.getter(InspectionDataRequest::protocol)).setter(InspectionDataRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("method").getter(InspectionDataRequest.getter(InspectionDataRequest::method)).setter(InspectionDataRequest.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(InspectionDataRequest.getter(InspectionDataRequest::url)).setter(InspectionDataRequest.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<String> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("headers").getter(InspectionDataRequest.getter(InspectionDataRequest::headers)).setter(InspectionDataRequest.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(InspectionDataRequest.getter(InspectionDataRequest::body)).setter(InspectionDataRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, METHOD_FIELD, URL_FIELD, HEADERS_FIELD, BODY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("protocol", PROTOCOL_FIELD);
            this.put("method", METHOD_FIELD);
            this.put("url", URL_FIELD);
            this.put("headers", HEADERS_FIELD);
            this.put("body", BODY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final String method;
    private final String url;
    private final String headers;
    private final String body;

    private InspectionDataRequest(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.method = builder.method;
        this.url = builder.url;
        this.headers = builder.headers;
        this.body = builder.body;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final String method() {
        return this.method;
    }

    public final String url() {
        return this.url;
    }

    public final String headers() {
        return this.headers;
    }

    public final String body() {
        return this.body;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.method());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.headers());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectionDataRequest)) {
            return false;
        }
        InspectionDataRequest other = (InspectionDataRequest)obj;
        return Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.method(), other.method()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.body(), other.body());
    }

    public final String toString() {
        return ToString.builder((String)"InspectionDataRequest").add("Protocol", (Object)this.protocol()).add("Method", (Object)this.method()).add("Url", (Object)this.url()).add("Headers", (Object)this.headers()).add("Body", (Object)this.body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "method": {
                return Optional.ofNullable(clazz.cast(this.method()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InspectionDataRequest, T> g) {
        return obj -> g.apply((InspectionDataRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private String method;
        private String url;
        private String headers;
        private String body;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectionDataRequest model) {
            this.protocol(model.protocol);
            this.method(model.method);
            this.url(model.url);
            this.headers(model.headers);
            this.body(model.body);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getHeaders() {
            return this.headers;
        }

        public final void setHeaders(String headers) {
            this.headers = headers;
        }

        @Override
        public final Builder headers(String headers) {
            this.headers = headers;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public InspectionDataRequest build() {
            return new InspectionDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InspectionDataRequest> {
        public Builder protocol(String var1);

        public Builder method(String var1);

        public Builder url(String var1);

        public Builder headers(String var1);

        public Builder body(String var1);
    }
}

