/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.IncludedData;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSyncExecutionRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, StartSyncExecutionRequest> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineArn").getter(StartSyncExecutionRequest.getter(StartSyncExecutionRequest::stateMachineArn)).setter(StartSyncExecutionRequest.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartSyncExecutionRequest.getter(StartSyncExecutionRequest::name)).setter(StartSyncExecutionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(StartSyncExecutionRequest.getter(StartSyncExecutionRequest::input)).setter(StartSyncExecutionRequest.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> TRACE_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceHeader").getter(StartSyncExecutionRequest.getter(StartSyncExecutionRequest::traceHeader)).setter(StartSyncExecutionRequest.setter(Builder::traceHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceHeader").build()}).build();
    private static final SdkField<String> INCLUDED_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("includedData").getter(StartSyncExecutionRequest.getter(StartSyncExecutionRequest::includedDataAsString)).setter(StartSyncExecutionRequest.setter(Builder::includedData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD, NAME_FIELD, INPUT_FIELD, TRACE_HEADER_FIELD, INCLUDED_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("stateMachineArn", STATE_MACHINE_ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("input", INPUT_FIELD);
            this.put("traceHeader", TRACE_HEADER_FIELD);
            this.put("includedData", INCLUDED_DATA_FIELD);
        }
    });
    private final String stateMachineArn;
    private final String name;
    private final String input;
    private final String traceHeader;
    private final String includedData;

    private StartSyncExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.input = builder.input;
        this.traceHeader = builder.traceHeader;
        this.includedData = builder.includedData;
    }

    public final String stateMachineArn() {
        return this.stateMachineArn;
    }

    public final String name() {
        return this.name;
    }

    public final String input() {
        return this.input;
    }

    public final String traceHeader() {
        return this.traceHeader;
    }

    public final IncludedData includedData() {
        return IncludedData.fromValue(this.includedData);
    }

    public final String includedDataAsString() {
        return this.includedData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.includedDataAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSyncExecutionRequest)) {
            return false;
        }
        StartSyncExecutionRequest other = (StartSyncExecutionRequest)((Object)obj);
        return Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.traceHeader(), other.traceHeader()) && Objects.equals(this.includedDataAsString(), other.includedDataAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartSyncExecutionRequest").add("StateMachineArn", (Object)this.stateMachineArn()).add("Name", (Object)this.name()).add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("TraceHeader", (Object)this.traceHeader()).add("IncludedData", (Object)this.includedDataAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "traceHeader": {
                return Optional.ofNullable(clazz.cast(this.traceHeader()));
            }
            case "includedData": {
                return Optional.ofNullable(clazz.cast(this.includedDataAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartSyncExecutionRequest, T> g) {
        return obj -> g.apply((StartSyncExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String stateMachineArn;
        private String name;
        private String input;
        private String traceHeader;
        private String includedData;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSyncExecutionRequest model) {
            super(model);
            this.stateMachineArn(model.stateMachineArn);
            this.name(model.name);
            this.input(model.input);
            this.traceHeader(model.traceHeader);
            this.includedData(model.includedData);
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInput() {
            return this.input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getTraceHeader() {
            return this.traceHeader;
        }

        public final void setTraceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
        }

        @Override
        public final Builder traceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
            return this;
        }

        public final String getIncludedData() {
            return this.includedData;
        }

        public final void setIncludedData(String includedData) {
            this.includedData = includedData;
        }

        @Override
        public final Builder includedData(String includedData) {
            this.includedData = includedData;
            return this;
        }

        @Override
        public final Builder includedData(IncludedData includedData) {
            this.includedData(includedData == null ? null : includedData.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSyncExecutionRequest build() {
            return new StartSyncExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSyncExecutionRequest> {
        public Builder stateMachineArn(String var1);

        public Builder name(String var1);

        public Builder input(String var1);

        public Builder traceHeader(String var1);

        public Builder includedData(String var1);

        public Builder includedData(IncludedData var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

