/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStateMachineResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, UpdateStateMachineResponse> {
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDate").getter(UpdateStateMachineResponse.getter(UpdateStateMachineResponse::updateDate)).setter(UpdateStateMachineResponse.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDate").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(UpdateStateMachineResponse.getter(UpdateStateMachineResponse::revisionId)).setter(UpdateStateMachineResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> STATE_MACHINE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineVersionArn").getter(UpdateStateMachineResponse.getter(UpdateStateMachineResponse::stateMachineVersionArn)).setter(UpdateStateMachineResponse.setter(Builder::stateMachineVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineVersionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_DATE_FIELD, REVISION_ID_FIELD, STATE_MACHINE_VERSION_ARN_FIELD));
    private final Instant updateDate;
    private final String revisionId;
    private final String stateMachineVersionArn;

    private UpdateStateMachineResponse(BuilderImpl builder) {
        super(builder);
        this.updateDate = builder.updateDate;
        this.revisionId = builder.revisionId;
        this.stateMachineVersionArn = builder.stateMachineVersionArn;
    }

    public final Instant updateDate() {
        return this.updateDate;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final String stateMachineVersionArn() {
        return this.stateMachineVersionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineVersionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStateMachineResponse)) {
            return false;
        }
        UpdateStateMachineResponse other = (UpdateStateMachineResponse)((Object)obj);
        return Objects.equals(this.updateDate(), other.updateDate()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.stateMachineVersionArn(), other.stateMachineVersionArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStateMachineResponse").add("UpdateDate", (Object)this.updateDate()).add("RevisionId", (Object)this.revisionId()).add("StateMachineVersionArn", (Object)this.stateMachineVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "updateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "stateMachineVersionArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineVersionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStateMachineResponse, T> g) {
        return obj -> g.apply((UpdateStateMachineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private Instant updateDate;
        private String revisionId;
        private String stateMachineVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStateMachineResponse model) {
            super(model);
            this.updateDate(model.updateDate);
            this.revisionId(model.revisionId);
            this.stateMachineVersionArn(model.stateMachineVersionArn);
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getStateMachineVersionArn() {
            return this.stateMachineVersionArn;
        }

        public final void setStateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
        }

        @Override
        public final Builder stateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
            return this;
        }

        @Override
        public UpdateStateMachineResponse build() {
            return new UpdateStateMachineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStateMachineResponse> {
        public Builder updateDate(Instant var1);

        public Builder revisionId(String var1);

        public Builder stateMachineVersionArn(String var1);
    }
}

