/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteStateMachineAliasRequest extends SfnRequest implements
        ToCopyableBuilder<DeleteStateMachineAliasRequest.Builder, DeleteStateMachineAliasRequest> {
    private static final SdkField<String> STATE_MACHINE_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineAliasArn").getter(getter(DeleteStateMachineAliasRequest::stateMachineAliasArn))
            .setter(setter(Builder::stateMachineAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineAliasArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STATE_MACHINE_ALIAS_ARN_FIELD));

    private final String stateMachineAliasArn;

    private DeleteStateMachineAliasRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineAliasArn = builder.stateMachineAliasArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine alias to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine alias to delete.
     */
    public final String stateMachineAliasArn() {
        return stateMachineAliasArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineAliasArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStateMachineAliasRequest)) {
            return false;
        }
        DeleteStateMachineAliasRequest other = (DeleteStateMachineAliasRequest) obj;
        return Objects.equals(stateMachineAliasArn(), other.stateMachineAliasArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteStateMachineAliasRequest").add("StateMachineAliasArn", stateMachineAliasArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineAliasArn":
            return Optional.ofNullable(clazz.cast(stateMachineAliasArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteStateMachineAliasRequest, T> g) {
        return obj -> g.apply((DeleteStateMachineAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteStateMachineAliasRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the state machine alias to delete.
         * </p>
         * 
         * @param stateMachineAliasArn
         *        The Amazon Resource Name (ARN) of the state machine alias to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineAliasArn(String stateMachineAliasArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String stateMachineAliasArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStateMachineAliasRequest model) {
            super(model);
            stateMachineAliasArn(model.stateMachineAliasArn);
        }

        public final String getStateMachineAliasArn() {
            return stateMachineAliasArn;
        }

        public final void setStateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
        }

        @Override
        public final Builder stateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteStateMachineAliasRequest build() {
            return new DeleteStateMachineAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
