/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sfn.SfnAsyncClient;
import software.amazon.awssdk.services.sfn.model.ListMapRunsRequest;
import software.amazon.awssdk.services.sfn.model.ListMapRunsResponse;
import software.amazon.awssdk.services.sfn.model.MapRunListItem;

public class ListMapRunsPublisher
implements SdkPublisher<ListMapRunsResponse> {
    private final SfnAsyncClient client;
    private final ListMapRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMapRunsPublisher(SfnAsyncClient client, ListMapRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMapRunsPublisher(SfnAsyncClient client, ListMapRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMapRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMapRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MapRunListItem> mapRuns() {
        Function<ListMapRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.mapRuns() != null) {
                return response.mapRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMapRunsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMapRunsResponseFetcher
    implements AsyncPageFetcher<ListMapRunsResponse> {
        private ListMapRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListMapRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMapRunsResponse> nextPage(ListMapRunsResponse previousPage) {
            if (previousPage == null) {
                return ListMapRunsPublisher.this.client.listMapRuns(ListMapRunsPublisher.this.firstRequest);
            }
            return ListMapRunsPublisher.this.client.listMapRuns((ListMapRunsRequest)((Object)ListMapRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

