/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.HistoryEventExecutionDataDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskSubmittedEventDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskSubmittedEventDetails> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(TaskSubmittedEventDetails.getter(TaskSubmittedEventDetails::resourceType)).setter(TaskSubmittedEventDetails.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(TaskSubmittedEventDetails.getter(TaskSubmittedEventDetails::resource)).setter(TaskSubmittedEventDetails.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("output").getter(TaskSubmittedEventDetails.getter(TaskSubmittedEventDetails::output)).setter(TaskSubmittedEventDetails.setter(Builder::output)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final SdkField<HistoryEventExecutionDataDetails> OUTPUT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDetails").getter(TaskSubmittedEventDetails.getter(TaskSubmittedEventDetails::outputDetails)).setter(TaskSubmittedEventDetails.setter(Builder::outputDetails)).constructor(HistoryEventExecutionDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_FIELD, OUTPUT_FIELD, OUTPUT_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String resource;
    private final String output;
    private final HistoryEventExecutionDataDetails outputDetails;

    private TaskSubmittedEventDetails(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resource = builder.resource;
        this.output = builder.output;
        this.outputDetails = builder.outputDetails;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resource() {
        return this.resource;
    }

    public final String output() {
        return this.output;
    }

    public final HistoryEventExecutionDataDetails outputDetails() {
        return this.outputDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSubmittedEventDetails)) {
            return false;
        }
        TaskSubmittedEventDetails other = (TaskSubmittedEventDetails)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.outputDetails(), other.outputDetails());
    }

    public final String toString() {
        return ToString.builder((String)"TaskSubmittedEventDetails").add("ResourceType", (Object)this.resourceType()).add("Resource", (Object)this.resource()).add("Output", (Object)(this.output() == null ? null : "*** Sensitive Data Redacted ***")).add("OutputDetails", (Object)this.outputDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "outputDetails": {
                return Optional.ofNullable(clazz.cast(this.outputDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskSubmittedEventDetails, T> g) {
        return obj -> g.apply((TaskSubmittedEventDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resource;
        private String output;
        private HistoryEventExecutionDataDetails outputDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskSubmittedEventDetails model) {
            this.resourceType(model.resourceType);
            this.resource(model.resource);
            this.output(model.output);
            this.outputDetails(model.outputDetails);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        @Transient
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getOutput() {
            return this.output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        @Transient
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final HistoryEventExecutionDataDetails.Builder getOutputDetails() {
            return this.outputDetails != null ? this.outputDetails.toBuilder() : null;
        }

        public final void setOutputDetails(HistoryEventExecutionDataDetails.BuilderImpl outputDetails) {
            this.outputDetails = outputDetails != null ? outputDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder outputDetails(HistoryEventExecutionDataDetails outputDetails) {
            this.outputDetails = outputDetails;
            return this;
        }

        public TaskSubmittedEventDetails build() {
            return new TaskSubmittedEventDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskSubmittedEventDetails> {
        public Builder resourceType(String var1);

        public Builder resource(String var1);

        public Builder output(String var1);

        public Builder outputDetails(HistoryEventExecutionDataDetails var1);

        default public Builder outputDetails(Consumer<HistoryEventExecutionDataDetails.Builder> outputDetails) {
            return this.outputDetails((HistoryEventExecutionDataDetails)((HistoryEventExecutionDataDetails.Builder)HistoryEventExecutionDataDetails.builder().applyMutation(outputDetails)).build());
        }
    }
}

