/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.CloudWatchEventsExecutionDataDetails;
import software.amazon.awssdk.services.sfn.model.ExecutionStatus;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExecutionResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, DescribeExecutionResponse> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionArn").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::executionArn)).setter(DescribeExecutionResponse.setter(Builder::executionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()}).build();
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineArn").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::stateMachineArn)).setter(DescribeExecutionResponse.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::name)).setter(DescribeExecutionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::statusAsString)).setter(DescribeExecutionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDate").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::startDate)).setter(DescribeExecutionResponse.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()}).build();
    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopDate").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::stopDate)).setter(DescribeExecutionResponse.setter(Builder::stopDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopDate").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::input)).setter(DescribeExecutionResponse.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<CloudWatchEventsExecutionDataDetails> INPUT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputDetails").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::inputDetails)).setter(DescribeExecutionResponse.setter(Builder::inputDetails)).constructor(CloudWatchEventsExecutionDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDetails").build()}).build();
    private static final SdkField<String> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("output").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::output)).setter(DescribeExecutionResponse.setter(Builder::output)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final SdkField<CloudWatchEventsExecutionDataDetails> OUTPUT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDetails").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::outputDetails)).setter(DescribeExecutionResponse.setter(Builder::outputDetails)).constructor(CloudWatchEventsExecutionDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDetails").build()}).build();
    private static final SdkField<String> TRACE_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceHeader").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::traceHeader)).setter(DescribeExecutionResponse.setter(Builder::traceHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceHeader").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD, STATE_MACHINE_ARN_FIELD, NAME_FIELD, STATUS_FIELD, START_DATE_FIELD, STOP_DATE_FIELD, INPUT_FIELD, INPUT_DETAILS_FIELD, OUTPUT_FIELD, OUTPUT_DETAILS_FIELD, TRACE_HEADER_FIELD));
    private final String executionArn;
    private final String stateMachineArn;
    private final String name;
    private final String status;
    private final Instant startDate;
    private final Instant stopDate;
    private final String input;
    private final CloudWatchEventsExecutionDataDetails inputDetails;
    private final String output;
    private final CloudWatchEventsExecutionDataDetails outputDetails;
    private final String traceHeader;

    private DescribeExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.status = builder.status;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
        this.input = builder.input;
        this.inputDetails = builder.inputDetails;
        this.output = builder.output;
        this.outputDetails = builder.outputDetails;
        this.traceHeader = builder.traceHeader;
    }

    public final String executionArn() {
        return this.executionArn;
    }

    public final String stateMachineArn() {
        return this.stateMachineArn;
    }

    public final String name() {
        return this.name;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant stopDate() {
        return this.stopDate;
    }

    public final String input() {
        return this.input;
    }

    public final CloudWatchEventsExecutionDataDetails inputDetails() {
        return this.inputDetails;
    }

    public final String output() {
        return this.output;
    }

    public final CloudWatchEventsExecutionDataDetails outputDetails() {
        return this.outputDetails;
    }

    public final String traceHeader() {
        return this.traceHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceHeader());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExecutionResponse)) {
            return false;
        }
        DescribeExecutionResponse other = (DescribeExecutionResponse)((Object)obj);
        return Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.stopDate(), other.stopDate()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.inputDetails(), other.inputDetails()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.outputDetails(), other.outputDetails()) && Objects.equals(this.traceHeader(), other.traceHeader());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExecutionResponse").add("ExecutionArn", (Object)this.executionArn()).add("StateMachineArn", (Object)this.stateMachineArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("StartDate", (Object)this.startDate()).add("StopDate", (Object)this.stopDate()).add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("InputDetails", (Object)this.inputDetails()).add("Output", (Object)(this.output() == null ? null : "*** Sensitive Data Redacted ***")).add("OutputDetails", (Object)this.outputDetails()).add("TraceHeader", (Object)this.traceHeader()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "stopDate": {
                return Optional.ofNullable(clazz.cast(this.stopDate()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "inputDetails": {
                return Optional.ofNullable(clazz.cast(this.inputDetails()));
            }
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "outputDetails": {
                return Optional.ofNullable(clazz.cast(this.outputDetails()));
            }
            case "traceHeader": {
                return Optional.ofNullable(clazz.cast(this.traceHeader()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExecutionResponse, T> g) {
        return obj -> g.apply((DescribeExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String executionArn;
        private String stateMachineArn;
        private String name;
        private String status;
        private Instant startDate;
        private Instant stopDate;
        private String input;
        private CloudWatchEventsExecutionDataDetails inputDetails;
        private String output;
        private CloudWatchEventsExecutionDataDetails outputDetails;
        private String traceHeader;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExecutionResponse model) {
            super(model);
            this.executionArn(model.executionArn);
            this.stateMachineArn(model.stateMachineArn);
            this.name(model.name);
            this.status(model.status);
            this.startDate(model.startDate);
            this.stopDate(model.stopDate);
            this.input(model.input);
            this.inputDetails(model.inputDetails);
            this.output(model.output);
            this.outputDetails(model.outputDetails);
            this.traceHeader(model.traceHeader);
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getStopDate() {
            return this.stopDate;
        }

        @Override
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final CloudWatchEventsExecutionDataDetails.Builder getInputDetails() {
            return this.inputDetails != null ? this.inputDetails.toBuilder() : null;
        }

        @Override
        public final Builder inputDetails(CloudWatchEventsExecutionDataDetails inputDetails) {
            this.inputDetails = inputDetails;
            return this;
        }

        public final void setInputDetails(CloudWatchEventsExecutionDataDetails.BuilderImpl inputDetails) {
            this.inputDetails = inputDetails != null ? inputDetails.build() : null;
        }

        public final String getOutput() {
            return this.output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        public final CloudWatchEventsExecutionDataDetails.Builder getOutputDetails() {
            return this.outputDetails != null ? this.outputDetails.toBuilder() : null;
        }

        @Override
        public final Builder outputDetails(CloudWatchEventsExecutionDataDetails outputDetails) {
            this.outputDetails = outputDetails;
            return this;
        }

        public final void setOutputDetails(CloudWatchEventsExecutionDataDetails.BuilderImpl outputDetails) {
            this.outputDetails = outputDetails != null ? outputDetails.build() : null;
        }

        public final String getTraceHeader() {
            return this.traceHeader;
        }

        @Override
        public final Builder traceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
            return this;
        }

        public final void setTraceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
        }

        @Override
        public DescribeExecutionResponse build() {
            return new DescribeExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExecutionResponse> {
        public Builder executionArn(String var1);

        public Builder stateMachineArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder startDate(Instant var1);

        public Builder stopDate(Instant var1);

        public Builder input(String var1);

        public Builder inputDetails(CloudWatchEventsExecutionDataDetails var1);

        default public Builder inputDetails(Consumer<CloudWatchEventsExecutionDataDetails.Builder> inputDetails) {
            return this.inputDetails((CloudWatchEventsExecutionDataDetails)((CloudWatchEventsExecutionDataDetails.Builder)CloudWatchEventsExecutionDataDetails.builder().applyMutation(inputDetails)).build());
        }

        public Builder output(String var1);

        public Builder outputDetails(CloudWatchEventsExecutionDataDetails var1);

        default public Builder outputDetails(Consumer<CloudWatchEventsExecutionDataDetails.Builder> outputDetails) {
            return this.outputDetails((CloudWatchEventsExecutionDataDetails)((CloudWatchEventsExecutionDataDetails.Builder)CloudWatchEventsExecutionDataDetails.builder().applyMutation(outputDetails)).build());
        }

        public Builder traceHeader(String var1);
    }
}

