/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.model.ExecutionListItem;
import software.amazon.awssdk.services.sfn.model.ListExecutionsRequest;
import software.amazon.awssdk.services.sfn.model.ListExecutionsResponse;

public class ListExecutionsIterable
implements SdkIterable<ListExecutionsResponse> {
    private final SfnClient client;
    private final ListExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExecutionsIterable(SfnClient client, ListExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListExecutionsResponseFetcher();
    }

    public Iterator<ListExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExecutionListItem> executions() {
        Function<ListExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.executions() != null) {
                return response.executions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExecutionsResponseFetcher
    implements SyncPageFetcher<ListExecutionsResponse> {
        private ListExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExecutionsResponse nextPage(ListExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListExecutionsIterable.this.client.listExecutions(ListExecutionsIterable.this.firstRequest);
            }
            return ListExecutionsIterable.this.client.listExecutions((ListExecutionsRequest)((Object)ListExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

