/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse;
import software.amazon.awssdk.services.sfn.model.HistoryEvent;

public class GetExecutionHistoryIterable
implements SdkIterable<GetExecutionHistoryResponse> {
    private final SfnClient client;
    private final GetExecutionHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetExecutionHistoryIterable(SfnClient client, GetExecutionHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetExecutionHistoryResponseFetcher();
    }

    public Iterator<GetExecutionHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HistoryEvent> events() {
        Function<GetExecutionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final GetExecutionHistoryIterable resume(GetExecutionHistoryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetExecutionHistoryIterable(this.client, (GetExecutionHistoryRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetExecutionHistoryIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetExecutionHistoryResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetExecutionHistoryResponseFetcher
    implements SyncPageFetcher<GetExecutionHistoryResponse> {
        private GetExecutionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetExecutionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetExecutionHistoryResponse nextPage(GetExecutionHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetExecutionHistoryIterable.this.client.getExecutionHistory(GetExecutionHistoryIterable.this.firstRequest);
            }
            return GetExecutionHistoryIterable.this.client.getExecutionHistory((GetExecutionHistoryRequest)((Object)GetExecutionHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

