/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HistoryEventType {
    ACTIVITY_FAILED("ActivityFailed"),
    ACTIVITY_SCHEDULE_FAILED("ActivityScheduleFailed"),
    ACTIVITY_SCHEDULED("ActivityScheduled"),
    ACTIVITY_STARTED("ActivityStarted"),
    ACTIVITY_SUCCEEDED("ActivitySucceeded"),
    ACTIVITY_TIMED_OUT("ActivityTimedOut"),
    CHOICE_STATE_ENTERED("ChoiceStateEntered"),
    CHOICE_STATE_EXITED("ChoiceStateExited"),
    EXECUTION_FAILED("ExecutionFailed"),
    EXECUTION_STARTED("ExecutionStarted"),
    EXECUTION_SUCCEEDED("ExecutionSucceeded"),
    EXECUTION_ABORTED("ExecutionAborted"),
    EXECUTION_TIMED_OUT("ExecutionTimedOut"),
    FAIL_STATE_ENTERED("FailStateEntered"),
    LAMBDA_FUNCTION_FAILED("LambdaFunctionFailed"),
    LAMBDA_FUNCTION_SCHEDULE_FAILED("LambdaFunctionScheduleFailed"),
    LAMBDA_FUNCTION_SCHEDULED("LambdaFunctionScheduled"),
    LAMBDA_FUNCTION_START_FAILED("LambdaFunctionStartFailed"),
    LAMBDA_FUNCTION_STARTED("LambdaFunctionStarted"),
    LAMBDA_FUNCTION_SUCCEEDED("LambdaFunctionSucceeded"),
    LAMBDA_FUNCTION_TIMED_OUT("LambdaFunctionTimedOut"),
    SUCCEED_STATE_ENTERED("SucceedStateEntered"),
    SUCCEED_STATE_EXITED("SucceedStateExited"),
    TASK_STATE_ABORTED("TaskStateAborted"),
    TASK_STATE_ENTERED("TaskStateEntered"),
    TASK_STATE_EXITED("TaskStateExited"),
    PASS_STATE_ENTERED("PassStateEntered"),
    PASS_STATE_EXITED("PassStateExited"),
    PARALLEL_STATE_ABORTED("ParallelStateAborted"),
    PARALLEL_STATE_ENTERED("ParallelStateEntered"),
    PARALLEL_STATE_EXITED("ParallelStateExited"),
    PARALLEL_STATE_FAILED("ParallelStateFailed"),
    PARALLEL_STATE_STARTED("ParallelStateStarted"),
    PARALLEL_STATE_SUCCEEDED("ParallelStateSucceeded"),
    WAIT_STATE_ABORTED("WaitStateAborted"),
    WAIT_STATE_ENTERED("WaitStateEntered"),
    WAIT_STATE_EXITED("WaitStateExited"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HistoryEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HistoryEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HistoryEventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HistoryEventType> knownValues() {
        return Stream.of(HistoryEventType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

