/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactListRequest extends SesV2Request implements
        ToCopyableBuilder<UpdateContactListRequest.Builder, UpdateContactListRequest> {
    private static final SdkField<String> CONTACT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactListName").getter(getter(UpdateContactListRequest::contactListName))
            .setter(setter(Builder::contactListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactListName").build()).build();

    private static final SdkField<List<Topic>> TOPICS_FIELD = SdkField
            .<List<Topic>> builder(MarshallingType.LIST)
            .memberName("Topics")
            .getter(getter(UpdateContactListRequest::topics))
            .setter(setter(Builder::topics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Topic> builder(MarshallingType.SDK_POJO)
                                            .constructor(Topic::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateContactListRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_NAME_FIELD,
            TOPICS_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contactListName;

    private final List<Topic> topics;

    private final String description;

    private UpdateContactListRequest(BuilderImpl builder) {
        super(builder);
        this.contactListName = builder.contactListName;
        this.topics = builder.topics;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the contact list.
     * </p>
     * 
     * @return The name of the contact list.
     */
    public final String contactListName() {
        return contactListName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Topics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTopics() {
        return topics != null && !(topics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An interest group, theme, or label within a list. A contact list can have multiple topics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopics} method.
     * </p>
     * 
     * @return An interest group, theme, or label within a list. A contact list can have multiple topics.
     */
    public final List<Topic> topics() {
        return topics;
    }

    /**
     * <p>
     * A description of what the contact list is about.
     * </p>
     * 
     * @return A description of what the contact list is about.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactListName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTopics() ? topics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactListRequest)) {
            return false;
        }
        UpdateContactListRequest other = (UpdateContactListRequest) obj;
        return Objects.equals(contactListName(), other.contactListName()) && hasTopics() == other.hasTopics()
                && Objects.equals(topics(), other.topics()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContactListRequest").add("ContactListName", contactListName())
                .add("Topics", hasTopics() ? topics() : null).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactListName":
            return Optional.ofNullable(clazz.cast(contactListName()));
        case "Topics":
            return Optional.ofNullable(clazz.cast(topics()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactListName", CONTACT_LIST_NAME_FIELD);
        map.put("Topics", TOPICS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactListRequest, T> g) {
        return obj -> g.apply((UpdateContactListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContactListRequest> {
        /**
         * <p>
         * The name of the contact list.
         * </p>
         * 
         * @param contactListName
         *        The name of the contact list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactListName(String contactListName);

        /**
         * <p>
         * An interest group, theme, or label within a list. A contact list can have multiple topics.
         * </p>
         * 
         * @param topics
         *        An interest group, theme, or label within a list. A contact list can have multiple topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(Collection<Topic> topics);

        /**
         * <p>
         * An interest group, theme, or label within a list. A contact list can have multiple topics.
         * </p>
         * 
         * @param topics
         *        An interest group, theme, or label within a list. A contact list can have multiple topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(Topic... topics);

        /**
         * <p>
         * An interest group, theme, or label within a list. A contact list can have multiple topics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.Topic.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sesv2.model.Topic#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.Topic.Builder#build()} is called immediately and its
         * result is passed to {@link #topics(List<Topic>)}.
         * 
         * @param topics
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.sesv2.model.Topic.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topics(java.util.Collection<Topic>)
         */
        Builder topics(Consumer<Topic.Builder>... topics);

        /**
         * <p>
         * A description of what the contact list is about.
         * </p>
         * 
         * @param description
         *        A description of what the contact list is about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String contactListName;

        private List<Topic> topics = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactListRequest model) {
            super(model);
            contactListName(model.contactListName);
            topics(model.topics);
            description(model.description);
        }

        public final String getContactListName() {
            return contactListName;
        }

        public final void setContactListName(String contactListName) {
            this.contactListName = contactListName;
        }

        @Override
        public final Builder contactListName(String contactListName) {
            this.contactListName = contactListName;
            return this;
        }

        public final List<Topic.Builder> getTopics() {
            List<Topic.Builder> result = TopicsCopier.copyToBuilder(this.topics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopics(Collection<Topic.BuilderImpl> topics) {
            this.topics = TopicsCopier.copyFromBuilder(topics);
        }

        @Override
        public final Builder topics(Collection<Topic> topics) {
            this.topics = TopicsCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Topic... topics) {
            topics(Arrays.asList(topics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Consumer<Topic.Builder>... topics) {
            topics(Stream.of(topics).map(c -> Topic.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactListRequest build() {
            return new UpdateContactListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
